/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCPrimaryKeyFinderTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCPrimaryKeyFinderTest
extends JDBCTestSupport {
    protected abstract JDBCPrimaryKeyFinderTestSetup createTestSetup();

    protected void setUp() throws Exception {
        super.setUp();
        this.dataStore.setDatabaseSchema(null);
    }

    public void testSequencedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("seqtable"));
        JDBCPrimaryKeyFinderTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyFinderTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof SequencedPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testAssignedSinglePKeyView() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("assignedsinglepk"));
        JDBCPrimaryKeyFinderTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyFinderTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
    }

    public void testAssignedMultiPKeyView() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("assignedmultipk"));
        JDBCPrimaryKeyFinderTest.assertEquals((int)2, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyFinderTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        JDBCPrimaryKeyFinderTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(1) instanceof NonIncrementingPrimaryKeyColumn));
        FeatureIterator i = fs.getFeatures().features();
        int j = 1;
        while (i.hasNext()) {
            SimpleFeature f = (SimpleFeature)i.next();
            JDBCPrimaryKeyFinderTest.assertEquals((String)(this.tname("assignedmultipk") + "." + j + "." + (j + 1)), (String)f.getID());
            ++j;
        }
        i.close();
    }

    void addFeature(SimpleFeatureType featureType, FeatureCollection features) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        b.add((Object)"four");
        b.add((Object)new GeometryFactory().createPoint(new Coordinate(4.0, 4.0)));
        SimpleFeature f = b.buildFeature(null);
        features.add((Feature)f);
        JDBCPrimaryKeyFinderTest.assertTrue((boolean)((String)f.getUserData().get("fid")).matches(this.tname(featureType.getTypeName()) + ".4(\\..*)?"));
    }

    void assertPrimaryKeyValues(FeatureCollection features, int count) throws Exception {
        FeatureIterator i = features.features();
        for (int j = 1; j <= count; ++j) {
            JDBCPrimaryKeyFinderTest.assertTrue((boolean)i.hasNext());
            SimpleFeature f = (SimpleFeature)i.next();
            JDBCPrimaryKeyFinderTest.assertEquals((String)(this.tname(features.getSchema().getName().getLocalPart()) + "." + j), (String)f.getID());
        }
        features.close(i);
    }
}

