/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.jdbc.datasource.DBCPDataSource;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.logging.Logging;

public abstract class JDBCTestSetup {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    private DataSource dataSource = null;

    public DataSource getDataSource() throws IOException {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    public void setUp() throws Exception {
    }

    protected void initializeDatabase() throws Exception {
    }

    protected void setUpData() throws Exception {
    }

    protected void setUpDataStore(JDBCDataStore dataStore) {
    }

    public void tearDown() throws Exception {
        if (this.dataSource instanceof BasicDataSource) {
            ((BasicDataSource)this.dataSource).close();
        } else if (this.dataSource instanceof ManageableDataSource) {
            ((ManageableDataSource)this.dataSource).close();
        }
    }

    protected void run(String input) throws Exception {
        this.run(new ByteArrayInputStream(input.getBytes()));
    }

    protected void runSafe(String input) {
        try {
            this.run(input);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(InputStream script) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(script));
        Connection conn = this.getConnection();
        try {
            Statement st = conn.createStatement();
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    LOGGER.fine(line);
                    st.execute(line);
                }
                reader.close();
            }
            finally {
                st.close();
            }
        }
        finally {
            conn.close();
        }
    }

    protected Connection getConnection() throws SQLException, IOException {
        Connection conn = this.getDataSource().getConnection();
        this.createDataStoreFactory().createSQLDialect(new JDBCDataStore()).initializeConnection(conn);
        return conn;
    }

    protected String typeName(String raw) {
        return raw;
    }

    protected String attributeName(String raw) {
        return raw;
    }

    protected DataSource createDataSource() throws IOException {
        Properties db = new Properties();
        this.fillConnectionProperties(db);
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(db.getProperty("driver"));
        dataSource.setUrl(db.getProperty("url"));
        if (db.containsKey("username")) {
            dataSource.setUsername(db.getProperty("username"));
        }
        if (db.containsKey("password")) {
            dataSource.setPassword(db.getProperty("password"));
        }
        dataSource.setPoolPreparedStatements(true);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        dataSource.setMinIdle(1);
        dataSource.setMaxActive(4);
        dataSource.setMaxWait(5000L);
        this.initializeDataSource(dataSource, db);
        return new DBCPDataSource(dataSource);
    }

    protected void fillConnectionProperties(Properties db) throws IOException {
        db.load(this.getClass().getResourceAsStream("db.properties"));
    }

    protected void initializeDataSource(BasicDataSource ds, Properties db) {
    }

    protected abstract JDBCDataStoreFactory createDataStoreFactory();

    protected final SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return null;
    }

    public boolean shouldRunTests(Connection cx) throws SQLException {
        return true;
    }
}

