/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.attributeio;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.attributeio.AttributeIO;

public class BasicAttributeIO
implements AttributeIO {
    public Object read(ResultSet rs, int position) throws IOException {
        try {
            return rs.getObject(position);
        }
        catch (SQLException e) {
            throw new DataSourceException("Sql problem.", (Throwable)e);
        }
    }

    public void write(ResultSet rs, int position, Object value) throws IOException {
        try {
            if (value == null) {
                rs.updateNull(position);
            } else {
                rs.updateObject(position, value);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Sql problem.", (Throwable)e);
        }
    }

    public void write(PreparedStatement ps, int position, Object value) throws IOException {
        try {
            if (value == null) {
                ps.setNull(position, 1111);
            } else {
                ps.setObject(position, value);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Sql problem.", (Throwable)e);
        }
    }
}

