/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.util.NoSuchElementException;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCClosingFeatureReader
implements DelegatingFeatureReader<SimpleFeatureType, SimpleFeature> {
    FeatureReader reader;

    public JDBCClosingFeatureReader(FeatureReader reader) {
        this.reader = reader;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getDelegate() {
        return this.reader;
    }

    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this.reader.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        return (SimpleFeature)this.reader.next();
    }

    public void close() throws IOException {
        FeatureReader r = this.reader;
        while (r instanceof DelegatingFeatureReader) {
            if (r instanceof JDBCFeatureReader) break;
            r = ((DelegatingFeatureReader)r).getDelegate();
        }
        if (r instanceof JDBCFeatureReader) {
            JDBCFeatureReader jdbcReader = (JDBCFeatureReader)r;
            JDBCFeatureSource fs = jdbcReader.featureSource;
            Connection cx = jdbcReader.cx;
            try {
                this.reader.close();
            }
            finally {
                fs.getDataStore().releaseConnection(cx, fs.getState());
            }
        }
    }
}

