/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.jdbc.SQLDialect;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataTablePrimaryKeyFinder
extends PrimaryKeyFinder {
    protected static final Logger LOGGER = Logging.getLogger(MetadataTablePrimaryKeyFinder.class);
    public static final String DEFAULT_TABLE = "GT_PK_METADATA";
    String tableSchema;
    String tableName = "GT_PK_METADATA";

    public String getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PrimaryKey getPrimaryKey(JDBCDataStore store, String schema, String table, Connection cx) throws SQLException {
        Statement st;
        ResultSet tables;
        ResultSet rs;
        block26: {
            StringBuffer sb;
            rs = null;
            tables = null;
            st = null;
            String metadataSchema = this.getMetadataSchema(store);
            try {
                try {
                    try {
                        st = cx.createStatement();
                        StringBuffer sb2 = new StringBuffer();
                        sb2.append("SELECT * FROM ");
                        if (metadataSchema != null) {
                            sb2.append(metadataSchema);
                            sb2.append(".");
                        }
                        sb2.append(this.tableName);
                        rs = st.executeQuery(sb2.toString());
                    }
                    catch (Exception sb2) {
                        store.closeSafe(rs);
                        store.closeSafe(st);
                        store.closeSafe(tables);
                        store.closeSafe(rs);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    store.closeSafe(rs);
                    throw throwable;
                }
                store.closeSafe(rs);
                SQLDialect dialect = store.getSQLDialect();
                sb = new StringBuffer();
                sb.append("SELECT * FROM ");
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Errors occurred accessing the primary key metadata table ", e);
                return null;
            }
            if (metadataSchema != null) {
                sb.append(metadataSchema);
                sb.append(".");
            }
            sb.append(this.tableName);
            sb.append(" WHERE ");
            if (schema != null) {
                sb.append("table_schema");
                sb.append(" = '" + schema + "' AND ");
            }
            sb.append("table_name");
            sb.append(" = '" + table + "'");
            sb.append(" ORDER BY ");
            sb.append("pk_column_idx");
            sb.append(" ASC");
            String sql = sb.toString();
            LOGGER.log(Level.FINE, "Reading metadata table metadata: {0}", sql);
            DatabaseMetaData metaData = cx.getMetaData();
            st = cx.createStatement();
            rs = st.executeQuery(sql);
            ArrayList<PrimaryKeyColumn> columns = new ArrayList<PrimaryKeyColumn>();
            Set<String> colNames = null;
            while (true) {
                if (!rs.next()) {
                    if (columns.size() > 0) {
                        break;
                    }
                    break block26;
                }
                String colName = rs.getString("pk_column");
                String policyStr = rs.getString("pk_policy");
                String sequence = rs.getString("pk_sequence");
                if (colNames == null) {
                    colNames = this.getColumnNames(metaData, schema, table);
                }
                if (!colNames.contains(colName)) {
                    LOGGER.warning("Unknown column " + colName + " in table " + table);
                    store.closeSafe(st);
                    store.closeSafe(tables);
                    store.closeSafe(rs);
                    return null;
                }
                Policy policy = Policy.assigned;
                if (policyStr != null) {
                    try {
                        policy = Policy.valueOf(policyStr.toLowerCase());
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warning("Invalid policy value " + policyStr + ", valid values are" + Arrays.asList(Policy.values()));
                        store.closeSafe(st);
                        store.closeSafe(tables);
                        store.closeSafe(rs);
                        return null;
                    }
                }
                Class columnType = store.getColumnType(metaData, schema, table, colName);
                if (policy == Policy.assigned) {
                    columns.add(new NonIncrementingPrimaryKeyColumn(colName, columnType));
                    continue;
                }
                if (policy == Policy.autogenerated) {
                    columns.add(new AutoGeneratedPrimaryKeyColumn(colName, columnType));
                    continue;
                }
                if (policy != Policy.sequence) continue;
                columns.add(new SequencedPrimaryKeyColumn(colName, columnType, sequence));
            }
            PrimaryKey primaryKey = new PrimaryKey(table, columns);
            store.closeSafe(st);
            store.closeSafe(tables);
            store.closeSafe(rs);
            return primaryKey;
        }
        store.closeSafe(st);
        store.closeSafe(tables);
        store.closeSafe(rs);
        return null;
        finally {
            store.closeSafe(st);
            store.closeSafe(tables);
            store.closeSafe(rs);
        }
    }

    Set<String> getColumnNames(DatabaseMetaData metaData, String schema, String table) throws SQLException {
        ResultSet rs = null;
        HashSet<String> result = new HashSet<String>();
        try {
            rs = metaData.getColumns(null, schema, table, null);
            while (rs.next()) {
                result.add(rs.getString("COLUMN_NAME"));
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    String getMetadataSchema(JDBCDataStore store) {
        if (this.tableSchema != null) {
            return this.tableSchema;
        }
        return store.getDatabaseSchema();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Policy {
        assigned,
        sequence,
        autogenerated;

    }
}

