/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCFeatureCollectionTest
extends JDBCTestSupport {
    SimpleFeatureCollection collection;

    protected void connect() throws Exception {
        super.connect();
        JDBCFeatureStore source = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        this.collection = source.getFeatures();
    }

    public void testIterator() throws Exception {
        Iterator i = this.collection.iterator();
        JDBCFeatureCollectionTest.assertNotNull((Object)i);
        int base = -1;
        for (int x = 0; x < 3; ++x) {
            JDBCFeatureCollectionTest.assertTrue((boolean)i.hasNext());
            SimpleFeature feature = (SimpleFeature)i.next();
            JDBCFeatureCollectionTest.assertNotNull((Object)feature);
            String fid = feature.getID();
            int id = Integer.parseInt(fid.substring(fid.indexOf(46) + 1));
            if (base == -1) {
                base = id;
            }
            JDBCFeatureCollectionTest.assertEquals((int)base++, (int)id);
            JDBCFeatureCollectionTest.assertEquals((int)x, (int)((Number)feature.getAttribute(this.aname("intProperty"))).intValue());
        }
        JDBCFeatureCollectionTest.assertFalse((boolean)i.hasNext());
        this.collection.close(i);
    }

    public void testBounds() throws IOException {
        ReferencedEnvelope bounds = this.collection.getBounds();
        JDBCFeatureCollectionTest.assertNotNull((Object)bounds);
        JDBCFeatureCollectionTest.assertEquals((double)0.0, (double)bounds.getMinX(), (double)0.1);
        JDBCFeatureCollectionTest.assertEquals((double)0.0, (double)bounds.getMinY(), (double)0.1);
        JDBCFeatureCollectionTest.assertEquals((double)2.0, (double)bounds.getMaxX(), (double)0.1);
        JDBCFeatureCollectionTest.assertEquals((double)2.0, (double)bounds.getMaxY(), (double)0.1);
    }

    public void testSize() throws IOException {
        JDBCFeatureCollectionTest.assertEquals((int)3, (int)this.collection.size());
    }

    public void testSubCollection() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        SimpleFeatureCollection sub = this.collection.subCollection((Filter)f);
        JDBCFeatureCollectionTest.assertNotNull((Object)sub);
        JDBCFeatureCollectionTest.assertEquals((int)1, (int)sub.size());
        ReferencedEnvelope exp = new ReferencedEnvelope(1.0, 1.0, 1.0, 1.0, CRS.decode((String)"EPSG:4326"));
        ReferencedEnvelope act = sub.getBounds();
        JDBCFeatureCollectionTest.assertEquals((double)exp.getMinX(), (double)act.getMinX(), (double)0.1);
        JDBCFeatureCollectionTest.assertEquals((double)exp.getMinY(), (double)act.getMinY(), (double)0.1);
        JDBCFeatureCollectionTest.assertEquals((double)exp.getMaxX(), (double)act.getMaxX(), (double)0.1);
        JDBCFeatureCollectionTest.assertEquals((double)exp.getMaxY(), (double)act.getMaxY(), (double)0.1);
        sub.clear();
        JDBCFeatureCollectionTest.assertEquals((int)2, (int)this.collection.size());
    }

    public void testAdd() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder((SimpleFeatureType)this.collection.getSchema());
        b.set(this.aname("intProperty"), (Object)new Integer(3));
        b.set(this.aname("doubleProperty"), (Object)new Double(3.3));
        b.set(this.aname("stringProperty"), (Object)"three");
        b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate(3.0, 3.0)));
        SimpleFeature feature = b.buildFeature(null);
        JDBCFeatureCollectionTest.assertEquals((int)3, (int)this.collection.size());
        this.collection.add((Feature)feature);
        JDBCFeatureCollectionTest.assertEquals((int)4, (int)this.collection.size());
        Iterator i = this.collection.iterator();
        boolean found = false;
        while (i.hasNext()) {
            SimpleFeature f = (SimpleFeature)i.next();
            if (!"three".equals(f.getAttribute(this.aname("stringProperty")))) continue;
            JDBCFeatureCollectionTest.assertEquals((Object)feature.getAttribute(this.aname("doubleProperty")), (Object)f.getAttribute(this.aname("doubleProperty")));
            JDBCFeatureCollectionTest.assertEquals((Object)feature.getAttribute(this.aname("stringProperty")), (Object)f.getAttribute(this.aname("stringProperty")));
            JDBCFeatureCollectionTest.assertTrue((boolean)((Geometry)feature.getAttribute(this.aname("geometry"))).equals((Geometry)f.getAttribute(this.aname("geometry"))));
            found = true;
        }
        JDBCFeatureCollectionTest.assertTrue((boolean)found);
        this.collection.close(i);
    }

    public void testClear() throws IOException {
        this.collection.clear();
        Iterator i = this.collection.iterator();
        JDBCFeatureCollectionTest.assertFalse((boolean)i.hasNext());
        this.collection.close(i);
    }
}

