/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.CollectionFeatureReader;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.FeatureEventWatcher;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;

public abstract class JDBCFeatureStoreTest
extends JDBCTestSupport {
    JDBCFeatureStore featureStore;

    protected void connect() throws Exception {
        super.connect();
        this.featureStore = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
    }

    public void testAddFeatures() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        FeatureEventWatcher watcher = new FeatureEventWatcher();
        for (int i = 3; i < 6; ++i) {
            b.set(this.aname("intProperty"), (Object)new Integer(i));
            b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate((double)i, (double)i)));
            collection.add(b.buildFeature(null));
        }
        this.featureStore.addFeatureListener((FeatureListener)watcher);
        List fids = this.featureStore.addFeatures((FeatureCollection)collection);
        JDBCFeatureStoreTest.assertEquals((Object)watcher.bounds, (Object)collection.getBounds());
        JDBCFeatureStoreTest.assertEquals((int)3, (int)fids.size());
        ContentFeatureCollection features = this.featureStore.getFeatures();
        JDBCFeatureStoreTest.assertEquals((int)6, (int)features.size());
        FilterFactory ff = this.dataStore.getFilterFactory();
        for (FeatureId identifier : fids) {
            String fid = identifier.getID();
            Id filter = ff.id(Collections.singleton(identifier));
            features = this.featureStore.getFeatures((Filter)filter);
            JDBCFeatureStoreTest.assertEquals((int)1, (int)features.size());
            Iterator iterator = features.iterator();
            JDBCFeatureStoreTest.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            JDBCFeatureStoreTest.assertEquals((String)fid, (String)feature.getID());
            JDBCFeatureStoreTest.assertFalse((boolean)iterator.hasNext());
            features.close(iterator);
        }
    }

    public void testAddFeaturesUseProvidedFid() throws IOException {
        JDBCFeatureStoreTest.assertTrue((boolean)this.featureStore.getQueryCapabilities().isUseProvidedFIDSupported());
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        String typeName = b.getFeatureType().getTypeName();
        for (int i = 3; i < 6; ++i) {
            b.set(this.aname("intProperty"), (Object)new Integer(i));
            b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate((double)i, (double)i)));
            b.featureUserData((Object)Hints.USE_PROVIDED_FID, (Object)Boolean.TRUE);
            collection.add(b.buildFeature(typeName + "." + i * 10));
        }
        List fids = this.featureStore.addFeatures((FeatureCollection)collection);
        JDBCFeatureStoreTest.assertEquals((int)3, (int)fids.size());
        JDBCFeatureStoreTest.assertTrue((boolean)fids.contains(SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)(typeName + ".30"))));
        JDBCFeatureStoreTest.assertTrue((boolean)fids.contains(SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)(typeName + ".40"))));
        JDBCFeatureStoreTest.assertTrue((boolean)fids.contains(SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)(typeName + ".50"))));
        ContentFeatureCollection features = this.featureStore.getFeatures();
        JDBCFeatureStoreTest.assertEquals((int)6, (int)features.size());
        FilterFactory ff = this.dataStore.getFilterFactory();
        for (FeatureId identifier : fids) {
            String fid = identifier.getID();
            Id filter = ff.id(Collections.singleton(identifier));
            features = this.featureStore.getFeatures((Filter)filter);
            JDBCFeatureStoreTest.assertEquals((int)1, (int)features.size());
        }
    }

    public void testAddInTransaction() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        b.set(this.aname("intProperty"), (Object)new Integer(3));
        b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate(3.0, 3.0)));
        collection.add(b.buildFeature(null));
        FeatureEventWatcher watcher = new FeatureEventWatcher();
        DefaultTransaction t = new DefaultTransaction();
        this.featureStore.setTransaction((Transaction)t);
        this.featureStore.addFeatureListener((FeatureListener)watcher);
        JDBCFeatureStore featureStore2 = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.featureStore.getName().getLocalPart());
        List fids = this.featureStore.addFeatures((FeatureCollection)collection);
        JDBCFeatureStoreTest.assertEquals((int)1, (int)fids.size());
        JDBCFeatureStoreTest.assertEquals((int)4, (int)this.featureStore.getFeatures().size());
        JDBCFeatureStoreTest.assertEquals((int)3, (int)featureStore2.getFeatures().size());
        t.commit();
        JDBCFeatureStoreTest.assertEquals((int)4, (int)this.featureStore.getFeatures().size());
        JDBCFeatureStoreTest.assertEquals((int)4, (int)featureStore2.getFeatures().size());
        t.close();
    }

    public void testExternalConnection() throws IOException, SQLException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        b.set(this.aname("intProperty"), (Object)new Integer(3));
        b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate(3.0, 3.0)));
        collection.add(b.buildFeature(null));
        FeatureEventWatcher watcher = new FeatureEventWatcher();
        Connection conn = this.setup.getDataSource().getConnection();
        conn.setAutoCommit(false);
        Transaction t = this.dataStore.buildTransaction(conn);
        this.featureStore.setTransaction(t);
        this.featureStore.addFeatureListener((FeatureListener)watcher);
        JDBCFeatureStore featureStore2 = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.featureStore.getName().getLocalPart());
        List fids = this.featureStore.addFeatures((FeatureCollection)collection);
        JDBCFeatureStoreTest.assertEquals((int)1, (int)fids.size());
        JDBCFeatureStoreTest.assertEquals((int)4, (int)this.featureStore.getFeatures().size());
        JDBCFeatureStoreTest.assertEquals((int)3, (int)featureStore2.getFeatures().size());
        t.commit();
        JDBCFeatureStoreTest.assertEquals((int)4, (int)this.featureStore.getFeatures().size());
        JDBCFeatureStoreTest.assertEquals((int)3, (int)featureStore2.getFeatures().size());
        conn.commit();
        JDBCFeatureStoreTest.assertEquals((int)4, (int)this.featureStore.getFeatures().size());
        JDBCFeatureStoreTest.assertEquals((int)4, (int)featureStore2.getFeatures().size());
        t.close();
        JDBCFeatureStoreTest.assertFalse((boolean)conn.isClosed());
        conn.close();
    }

    public void testAddNullAttributes() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        SimpleFeature nullFeature = b.buildFeature("testId");
        this.featureStore.addFeatures(Arrays.asList(nullFeature));
    }

    public void testModifyNullAttributes() throws IOException {
        String[] attributeNames = new String[this.featureStore.getSchema().getAttributeCount()];
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeNames[i] = this.featureStore.getSchema().getDescriptor(i).getLocalName();
        }
        Object[] nulls = new Object[attributeNames.length];
        this.featureStore.modifyFeatures(attributeNames, nulls, (Filter)Filter.INCLUDE);
    }

    public void testSetFeatures() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        for (int i = 3; i < 6; ++i) {
            b.set(this.aname("intProperty"), (Object)new Integer(i));
            b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate((double)i, (double)i)));
            collection.add(b.buildFeature(null));
        }
        CollectionFeatureReader reader = new CollectionFeatureReader((SimpleFeatureCollection)collection, collection.getSchema());
        this.featureStore.setFeatures((FeatureReader)reader);
        ContentFeatureCollection features = this.featureStore.getFeatures();
        JDBCFeatureStoreTest.assertEquals((int)3, (int)features.size());
        Iterator iterator = features.iterator();
        HashSet<Integer> numbers = new HashSet<Integer>();
        numbers.add(new Integer(3));
        numbers.add(new Integer(4));
        numbers.add(new Integer(5));
        int i = 3;
        while (iterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iterator.next();
            JDBCFeatureStoreTest.assertTrue((boolean)numbers.contains(((Number)feature.getAttribute(this.aname("intProperty"))).intValue()));
            numbers.remove(feature.getAttribute(this.aname("intProperty")));
            ++i;
        }
        features.close(iterator);
    }

    public void testModifyFeatures() throws IOException {
        FeatureEventWatcher watcher = new FeatureEventWatcher();
        SimpleFeatureType t = this.featureStore.getSchema();
        this.featureStore.addFeatureListener((FeatureListener)watcher);
        this.featureStore.modifyFeatures(new AttributeDescriptor[]{t.getDescriptor(this.aname("stringProperty"))}, new Object[]{"foo"}, (Filter)Filter.INCLUDE);
        JDBCFeatureStoreTest.assertTrue((String)"check that at least one event was issued", (watcher.count > 0 ? 1 : 0) != 0);
        JDBCFeatureStoreTest.assertEquals((String)"Should be an update event", (Object)FeatureEvent.Type.CHANGED, (Object)watcher.type);
        JDBCFeatureStoreTest.assertEquals((Object)Filter.INCLUDE, (Object)watcher.filter);
        ContentFeatureCollection features = this.featureStore.getFeatures();
        Iterator i = features.iterator();
        JDBCFeatureStoreTest.assertTrue((boolean)i.hasNext());
        while (i.hasNext()) {
            SimpleFeature feature = (SimpleFeature)i.next();
            JDBCFeatureStoreTest.assertEquals((Object)"foo", (Object)feature.getAttribute(this.aname("stringProperty")));
        }
        features.close(i);
    }

    public void testModifyGeometry() throws IOException {
        SimpleFeatureType t = this.featureStore.getSchema();
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(-10.0, 0.0));
        this.featureStore.modifyFeatures(new AttributeDescriptor[]{t.getDescriptor(this.aname("geometry"))}, new Object[]{point}, (Filter)Filter.INCLUDE);
        ContentFeatureCollection features = this.featureStore.getFeatures();
        Iterator i = features.iterator();
        JDBCFeatureStoreTest.assertTrue((boolean)i.hasNext());
        while (i.hasNext()) {
            SimpleFeature feature = (SimpleFeature)i.next();
            JDBCFeatureStoreTest.assertTrue((boolean)point.equalsExact((Geometry)feature.getAttribute(this.aname("geometry"))));
        }
        features.close(i);
    }

    public void testModifyMadeUpGeometry() throws IOException {
        SimpleFeatureType t = this.featureStore.getSchema();
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(-10.0, 0.0));
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        ab.binding(Point.class);
        AttributeDescriptor madeUp = ab.buildDescriptor(this.aname("geometry"));
        this.featureStore.modifyFeatures(new AttributeDescriptor[]{madeUp}, new Object[]{point}, (Filter)Filter.INCLUDE);
        ContentFeatureCollection features = this.featureStore.getFeatures();
        Iterator i = features.iterator();
        JDBCFeatureStoreTest.assertTrue((boolean)i.hasNext());
        while (i.hasNext()) {
            SimpleFeature feature = (SimpleFeature)i.next();
            JDBCFeatureStoreTest.assertTrue((boolean)point.equalsExact((Geometry)feature.getAttribute(this.aname("geometry"))));
        }
        features.close(i);
    }

    public void testModifyFeaturesSingleAttribute() throws IOException {
        SimpleFeatureType t = this.featureStore.getSchema();
        this.featureStore.modifyFeatures(t.getDescriptor(this.aname("stringProperty")), (Object)"foo", (Filter)Filter.INCLUDE);
        ContentFeatureCollection features = this.featureStore.getFeatures();
        Iterator i = features.iterator();
        JDBCFeatureStoreTest.assertTrue((boolean)i.hasNext());
        while (i.hasNext()) {
            SimpleFeature feature = (SimpleFeature)i.next();
            JDBCFeatureStoreTest.assertEquals((Object)"foo", (Object)feature.getAttribute(this.aname("stringProperty")));
        }
        features.close(i);
    }

    public void testModifyFeaturesInvalidFilter() throws IOException {
        SimpleFeatureType t = this.featureStore.getSchema();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        try {
            this.featureStore.modifyFeatures(new AttributeDescriptor[]{t.getDescriptor(this.aname("stringProperty"))}, new Object[]{"foo"}, (Filter)f);
            JDBCFeatureStoreTest.fail((String)"This should have failed with an exception reporting the invalid filter");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testRemoveFeatures() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        ContentFeatureCollection features = this.featureStore.getFeatures();
        JDBCFeatureStoreTest.assertEquals((int)3, (int)features.size());
        this.featureStore.removeFeatures((Filter)filter);
        JDBCFeatureStoreTest.assertEquals((int)2, (int)features.size());
        this.featureStore.removeFeatures((Filter)Filter.INCLUDE);
        JDBCFeatureStoreTest.assertEquals((int)0, (int)features.size());
    }

    public void testRemoveFeaturesWithInvalidFilter() throws IOException {
        SimpleFeatureType t = this.featureStore.getSchema();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        try {
            this.featureStore.removeFeatures((Filter)f);
            JDBCFeatureStoreTest.fail((String)"This should have failed with an exception reporting the invalid filter");
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

