/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCGeometrylessTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCGeometrylessTest
extends JDBCTestSupport {
    protected SimpleFeatureType personSchema;
    protected SimpleFeatureType zipCodeSchema;
    protected static final String PERSON = "person";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String AGE = "age";
    protected static final String ZIPCODE = "zipcode";
    protected static final String CODE = "code";

    protected abstract JDBCGeometrylessTestSetup createTestSetup();

    protected void connect() throws Exception {
        super.connect();
        this.personSchema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + PERSON), (String)"id:0,name:String,age:0");
        this.zipCodeSchema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + ZIPCODE), (String)"id:0,code:String");
    }

    public void testPersonSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(PERSON));
        this.assertFeatureTypesEqual(this.personSchema, ft);
    }

    public void testReadFeatures() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(PERSON)).getFeatures();
        JDBCGeometrylessTest.assertEquals((int)2, (int)fc.size());
        SimpleFeatureIterator fr = fc.features();
        JDBCGeometrylessTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature f = (SimpleFeature)fr.next();
        JDBCGeometrylessTest.assertTrue((boolean)fr.hasNext());
        f = (SimpleFeature)fr.next();
        JDBCGeometrylessTest.assertFalse((boolean)fr.hasNext());
        fr.close();
    }

    public void testGetBounds() throws Exception {
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname(PERSON)).getBounds();
        JDBCGeometrylessTest.assertTrue((boolean)env.isEmpty());
    }

    public void testCreate() throws Exception {
        this.dataStore.createSchema(this.zipCodeSchema);
        this.assertFeatureTypesEqual(this.zipCodeSchema, this.dataStore.getSchema(this.tname(ZIPCODE)));
    }

    public void testWriteFeatures() throws Exception {
        FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname(PERSON), Transaction.AUTO_COMMIT);
        SimpleFeature f = (SimpleFeature)fw.next();
        f.setAttribute(this.aname(NAME), (Object)"Joe");
        f.setAttribute(this.aname(AGE), (Object)27);
        fw.write();
        fw.close();
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(PERSON)).getFeatures();
        JDBCGeometrylessTest.assertEquals((int)3, (int)fc.size());
    }
}

