/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFinder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCJNDIDataStoreFactory;
import org.geotools.jdbc.JDBCJNDITestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.SQLDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBCJNDIDataSourceTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCJNDITestSetup createTestSetup();

    public void testJNDIDataSource() throws Exception {
        ((JDBCJNDITestSetup)this.setup).setupJNDIEnvironment();
        HashMap<String, String> params = new HashMap<String, String>();
        String dbtype = this.setup.createDataStoreFactory().getDatabaseID();
        params.put(JDBCDataStoreFactory.NAMESPACE.key, "http://www.geotools.org/test");
        params.put(JDBCDataStoreFactory.DBTYPE.key, dbtype);
        params.put(JDBCJNDIDataStoreFactory.JNDI_REFNAME.key, "ds");
        JDBCDataStore dataStore = (JDBCDataStore)DataStoreFinder.getDataStore(params);
        Connection con = dataStore.getDataSource().getConnection();
        JDBCJNDIDataSourceTest.assertTrue((con != null ? 1 : 0) != 0);
        JDBCJNDIDataSourceTest.assertFalse((boolean)con.isClosed());
        dataStore.closeSafe(con);
    }

    public void testExtraParams() {
        List<String> baseParams = this.getBaseParams();
        List<String> standardParams = this.getParamKeys(this.getDataStoreFactory());
        standardParams.remove(JDBCDataStoreFactory.VALIDATECONN.key);
        standardParams.remove(JDBCDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key);
        standardParams.removeAll(baseParams);
        List<String> baseJndiParams = this.getBaseJNDIParams();
        List<String> jndiParams = this.getParamKeys((JDBCDataStoreFactory)this.getJNDIStoreFactory());
        jndiParams.removeAll(baseJndiParams);
        JDBCJNDIDataSourceTest.assertEquals(standardParams, jndiParams);
    }

    protected abstract JDBCJNDIDataStoreFactory getJNDIStoreFactory();

    protected abstract JDBCDataStoreFactory getDataStoreFactory();

    protected List<String> getBaseParams() {
        JDBCDataStoreFactory factory = this.getBaseFactory();
        return this.getParamKeys(factory);
    }

    protected JDBCDataStoreFactory getBaseFactory() {
        JDBCDataStoreFactory factory = new JDBCDataStoreFactory(){

            public String getDescription() {
                return null;
            }

            protected String getValidationQuery() {
                return null;
            }

            protected String getDriverClassName() {
                return null;
            }

            protected String getDatabaseID() {
                return null;
            }

            protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
                return null;
            }
        };
        return factory;
    }

    protected List<String> getBaseJNDIParams() {
        JDBCJNDIDataStoreFactory factory = new JDBCJNDIDataStoreFactory(this.getBaseFactory()){};
        return this.getParamKeys((JDBCDataStoreFactory)factory);
    }

    protected List<String> getParamKeys(JDBCDataStoreFactory factory) {
        DataAccessFactory.Param[] params = factory.getParametersInfo();
        ArrayList<String> results = new ArrayList<String>();
        for (DataAccessFactory.Param p : params) {
            results.add(p.key);
        }
        return results;
    }
}

