/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSetup;
import org.geotools.jdbc.SQLDialect;
import org.geotools.test.OnlineTestCase;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCTestSupport
extends OnlineTestCase {
    protected JDBCTestSetup setup;
    protected JDBCDataStore dataStore;
    protected SQLDialect dialect;

    protected Properties createOfflineFixture() {
        return this.createTestSetup().createOfflineFixture();
    }

    protected Properties createExampleFixture() {
        return this.createTestSetup().createExampleFixture();
    }

    protected String getFixtureId() {
        return this.createTestSetup().createDataStoreFactory().getDatabaseID();
    }

    protected boolean isOnline() throws Exception {
        JDBCTestSetup setup = this.createTestSetup();
        setup.setFixture(this.fixture);
        try {
            DataSource dataSource = setup.getDataSource();
            Connection cx = dataSource.getConnection();
            cx.close();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            try {
                setup.tearDown();
            }
            catch (Exception e) {
                System.out.println("Error occurred tearing down the test setup");
            }
        }
    }

    protected void connect() throws Exception {
        if (this.setup == null) {
            this.setup = this.createTestSetup();
        }
        this.setup.setFixture(this.fixture);
        this.setup.setUp();
        this.setup.initializeDatabase();
        this.setup.setUpData();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(JDBCDataStoreFactory.NAMESPACE.key, "http://www.geotools.org/test");
        params.put(JDBCDataStoreFactory.SCHEMA.key, "geotools");
        params.put(JDBCDataStoreFactory.DATASOURCE.key, this.setup.getDataSource());
        JDBCDataStoreFactory factory = this.setup.createDataStoreFactory();
        this.dataStore = factory.createDataStore(params);
        this.setup.setUpDataStore(this.dataStore);
        this.dialect = this.dataStore.getSQLDialect();
    }

    protected abstract JDBCTestSetup createTestSetup();

    protected void disconnect() throws Exception {
        this.setup.tearDown();
        this.dataStore.dispose();
    }

    protected String tname(String raw) {
        return this.setup.typeName(raw);
    }

    protected String aname(String raw) {
        return this.setup.attributeName(raw);
    }

    protected Name aname(Name raw) {
        return new NameImpl(raw.getNamespaceURI(), this.aname(raw.getLocalPart()));
    }

    protected void assertFeatureTypesEqual(SimpleFeatureType expected, SimpleFeatureType actual) {
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            AttributeDescriptor expectedAttribute = expected.getDescriptor(i);
            AttributeDescriptor actualAttribute = actual.getDescriptor(i);
            this.assertAttributesEqual(expectedAttribute, actualAttribute);
        }
        if (expected.getGeometryDescriptor() != null) {
            GeometryDescriptor dg = actual.getGeometryDescriptor();
            JDBCTestSupport.assertTrue((boolean)dg.isNillable());
            JDBCTestSupport.assertEquals((int)0, (int)dg.getMinOccurs());
        }
    }

    protected void assertAttributesEqual(AttributeDescriptor expected, AttributeDescriptor actual) {
        JDBCTestSupport.assertEquals((Object)this.aname(expected.getName()), (Object)actual.getName());
        JDBCTestSupport.assertEquals((int)expected.getMinOccurs(), (int)actual.getMinOccurs());
        JDBCTestSupport.assertEquals((int)expected.getMaxOccurs(), (int)actual.getMaxOccurs());
        JDBCTestSupport.assertEquals((boolean)expected.isNillable(), (boolean)actual.isNillable());
        JDBCTestSupport.assertEquals((Object)expected.getDefaultValue(), (Object)actual.getDefaultValue());
        AttributeType texpected = expected.getType();
        AttributeType tactual = actual.getType();
        if (Number.class.isAssignableFrom(texpected.getBinding())) {
            JDBCTestSupport.assertTrue((boolean)Number.class.isAssignableFrom(tactual.getBinding()));
        } else if (Geometry.class.isAssignableFrom(texpected.getBinding())) {
            JDBCTestSupport.assertTrue((boolean)Geometry.class.isAssignableFrom(tactual.getBinding()));
        } else {
            JDBCTestSupport.assertTrue((boolean)texpected.getBinding().isAssignableFrom(tactual.getBinding()));
        }
    }

    protected boolean areCRSEqual(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        if (crs1 == null && crs2 == null) {
            return true;
        }
        if (crs1 == null) {
            return false;
        }
        return crs1.equals(crs2);
    }

    protected boolean areReferencedEnvelopesEuqal(ReferencedEnvelope e1, ReferencedEnvelope e2) {
        boolean equal;
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        boolean bl = equal = Math.round(e1.getMinX()) == Math.round(e2.getMinX()) && Math.round(e1.getMinY()) == Math.round(e2.getMinY()) && Math.round(e1.getMaxX()) == Math.round(e2.getMaxX()) && Math.round(e1.getMaxY()) == Math.round(e2.getMaxY());
        if (!equal) {
            return false;
        }
        return this.areCRSEqual(e1.getCoordinateReferenceSystem(), e2.getCoordinateReferenceSystem());
    }
}

