/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.function.EnvFunction;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SessionCommandsListener;
import org.junit.Assert;
import org.junit.Test;

public class SessionCommandListenerTest {
    RecordingConnection conn = new RecordingConnection();
    JDBCDataStore store = new JDBCDataStore();

    @Test
    public void testPlain() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener("A", "B");
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"A", (Object)this.conn.commands.get(0));
        this.conn.commands.clear();
        listener.onRelease(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"B", (Object)this.conn.commands.get(0));
    }

    @Test
    public void testOnlyBorrow() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener("A", null);
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"A", (Object)this.conn.commands.get(0));
        this.conn.commands.clear();
        listener.onRelease(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)0L, (long)this.conn.commands.size());
    }

    @Test
    public void testOnlyRelease() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener(null, "B");
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)0L, (long)this.conn.commands.size());
        listener.onRelease(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"B", (Object)this.conn.commands.get(0));
    }

    @Test
    public void testExpandVariables() throws Exception {
        SessionCommandsListener listener = new SessionCommandsListener("call startSession('${user}')", "call endSession('${user,joe}')");
        EnvFunction.setLocalValue((String)"user", (Object)"abcde");
        listener.onBorrow(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"call startSession('abcde')", (Object)this.conn.commands.get(0));
        this.conn.commands.clear();
        EnvFunction.clearLocalValues();
        listener.onRelease(this.store, (Connection)((Object)this.conn));
        Assert.assertEquals((long)1L, (long)this.conn.commands.size());
        Assert.assertEquals((Object)"call endSession('joe')", (Object)this.conn.commands.get(0));
        this.conn.commands.clear();
    }

    @Test
    public void testInvalid() throws Exception {
        try {
            new SessionCommandsListener("startSession('${user')", null);
            Assert.fail((String)"This should have failed, the syntax is not valid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class RecordingConnection
    extends MockConnection {
        List<String> commands = new ArrayList<String>();

        RecordingConnection() {
        }

        public Statement createStatement() throws SQLException {
            return new MockStatement((Connection)((Object)this)){

                public boolean execute(String sql) throws SQLException {
                    RecordingConnection.this.commands.add(sql);
                    return false;
                }
            };
        }
    }
}

