/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.attributeio;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.factory.Hints;

public class WKBAttributeIO
implements AttributeIO {
    WKBReader wkbr;
    ByteArrayInStream inStream = new ByteArrayInStream();

    public WKBAttributeIO() {
        this.wkbr = new WKBReader();
    }

    public WKBAttributeIO(Hints hints) {
        GeometryFactory gf = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (gf == null) {
            Integer SRID;
            PrecisionModel pm = (PrecisionModel)hints.get((Object)Hints.JTS_PRECISION_MODEL);
            if (pm == null) {
                pm = new PrecisionModel();
            }
            int srid = (SRID = (Integer)hints.get((Object)Hints.JTS_SRID)) == null ? 0 : SRID;
            CoordinateSequenceFactory csFactory = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
            if (csFactory == null) {
                csFactory = CoordinateArraySequenceFactory.instance();
            }
            gf = new GeometryFactory(pm, srid, csFactory);
        }
        this.wkbr = new WKBReader(gf);
    }

    private Geometry WKB2Geometry(byte[] wkbBytes) throws IOException {
        if (wkbBytes == null) {
            return null;
        }
        try {
            this.inStream.setBytes(wkbBytes);
            return this.wkbr.read((InStream)this.inStream);
        }
        catch (Exception e) {
            throw new DataSourceException("An exception occurred while parsing WKB data", (Throwable)e);
        }
    }

    public Object read(ResultSet rs, int position) throws IOException {
        try {
            byte[] bytes = rs.getBytes(position);
            if (bytes == null) {
                return null;
            }
            return this.WKB2Geometry(bytes);
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    public void write(ResultSet rs, int position, Object value) throws IOException {
        try {
            if (value == null) {
                rs.updateNull(position);
            } else {
                rs.updateBytes(position, new WKBWriter().write((Geometry)value));
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    public void write(PreparedStatement ps, int position, Object value) throws IOException {
        try {
            if (value == null) {
                ps.setNull(position, 1111);
            } else {
                ps.setBytes(position, new WKBWriter().write((Geometry)value));
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    private static class ByteArrayInStream
    implements InStream {
        byte[] buffer;
        int position;

        private ByteArrayInStream() {
        }

        public void setBytes(byte[] buffer) {
            this.buffer = buffer;
            this.position = 0;
        }

        public void read(byte[] buf) throws IOException {
            int size = buf.length;
            System.arraycopy(this.buffer, this.position, buf, 0, size);
            this.position += size;
        }
    }
}

