/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    protected QueryData queryData;
    protected FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    protected SimpleFeature live;
    protected SimpleFeature current;
    protected boolean closed;
    protected Object[] fidAttributes;

    public JDBCFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> reader, QueryData queryData) {
        this.reader = reader;
        this.queryData = queryData;
    }

    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this.reader.getFeatureType();
    }

    public SimpleFeature next() throws IOException {
        if (this.reader == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        SimpleFeatureType featureType = this.getFeatureType();
        if (this.hasNext()) {
            try {
                this.live = (SimpleFeature)this.reader.next();
                this.current = SimpleFeatureBuilder.copy((SimpleFeature)this.live);
                LOGGER.finer("Calling next on writer");
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Unable to edit " + this.live.getID() + " of " + featureType.getTypeName(), (Throwable)e);
            }
        }
        this.live = null;
        try {
            SimpleFeature temp = SimpleFeatureBuilder.template((SimpleFeatureType)featureType, null);
            this.current = new MutableFIDFeature(temp.getAttributes(), featureType, null);
            if (this.useQueryDataForInsert()) {
                this.queryData.startInsert();
            }
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Unable to add additional Features of " + featureType.getTypeName(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new DataSourceException("Unable to move to insert row. " + e.getMessage(), (Throwable)e);
        }
        return this.current;
    }

    protected boolean useQueryDataForInsert() {
        return true;
    }

    public void remove() throws IOException {
        if (this.closed) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to remove");
        }
        if (this.live != null) {
            LOGGER.fine("Removing " + this.live);
            ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)this.live.getBounds());
            this.live = null;
            this.current = null;
            Transaction transaction = this.queryData.getTransaction();
            try {
                this.queryData.deleteCurrentRow();
                this.queryData.fireChangeRemoved(bounds, false);
            }
            catch (SQLException sqle) {
                String message = "problem deleting row";
                if (transaction != Transaction.AUTO_COMMIT) {
                    transaction.rollback();
                    message = message + "(transaction canceled)";
                }
                throw new DataSourceException(message, (Throwable)sqle);
            }
        } else {
            this.current = null;
        }
    }

    public void write() throws IOException {
        if (this.closed) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to write");
        }
        LOGGER.fine("write called, live is " + this.live + " and cur is " + this.current);
        if (this.live != null) {
            if (this.live.equals(this.current)) {
                this.live = null;
                this.current = null;
            } else {
                try {
                    this.doUpdate(this.live, this.current);
                    ReferencedEnvelope bounds = new ReferencedEnvelope();
                    bounds.include(this.live.getBounds());
                    bounds.include(this.current.getBounds());
                    this.queryData.fireFeaturesChanged(bounds, false);
                }
                catch (SQLException sqlException) {
                    this.queryData.close(sqlException);
                    throw new DataSourceException("Error updating row", (Throwable)sqlException);
                }
                this.live = null;
                this.current = null;
            }
        } else {
            LOGGER.fine("doing insert in jdbc featurewriter");
            try {
                this.doInsert((MutableFIDFeature)this.current);
                this.queryData.fireFeaturesAdded(ReferencedEnvelope.reference((BoundingBox)this.current.getBounds()), false);
            }
            catch (SQLException e) {
                throw new DataSourceException("Row adding failed.", (Throwable)e);
            }
            this.current = null;
        }
    }

    protected void doUpdate(SimpleFeature live, SimpleFeature current) throws IOException, SQLException {
        try {
            for (int i = 0; i < current.getAttributeCount(); ++i) {
                Object currAtt = current.getAttribute(i);
                Object liveAtt = live.getAttribute(i);
                if (live != null && DataUtilities.attributesEqual((Object)liveAtt, (Object)currAtt)) continue;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("modifying att# " + i + " to " + currAtt);
                }
                this.queryData.write(i, currAtt);
            }
        }
        catch (IOException ioe) {
            String message = "problem modifying row";
            if (this.queryData.getTransaction() != Transaction.AUTO_COMMIT) {
                this.queryData.getTransaction().rollback();
                message = message + "(transaction canceled)";
            }
            throw ioe;
        }
        this.queryData.updateRow();
    }

    protected void doInsert(MutableFIDFeature mutable) throws IOException, SQLException {
        int i;
        this.queryData.startInsert();
        FIDMapper mapper = this.queryData.getMapper();
        Set<String> autoincrementColumns = null;
        if (mapper.getColumnCount() > 0 && !mapper.returnFIDColumnsAsAttributes()) {
            autoincrementColumns = Collections.EMPTY_SET;
            String ID = mapper.createID(this.queryData.getConnection(), (SimpleFeature)mutable, null);
            this.fidAttributes = mapper.getPKAttributes(ID);
            if (this.fidAttributes != null) {
                mutable.setID(ID);
                for (int i2 = 0; i2 < this.fidAttributes.length; ++i2) {
                    Object fidAttribute = this.fidAttributes[i2];
                    if (mapper.isAutoIncrement(i2)) continue;
                    this.queryData.writeFidColumn(i2, fidAttribute);
                }
            }
        } else {
            autoincrementColumns = new HashSet();
            for (int i3 = 0; i3 < mapper.getColumnCount(); ++i3) {
                if (!mapper.isAutoIncrement(i3)) continue;
                autoincrementColumns.add(mapper.getColumnName(i3));
            }
        }
        for (i = 0; i < this.current.getAttributeCount(); ++i) {
            Object currAtt = this.current.getAttribute(i);
            String attName = this.current.getFeatureType().getDescriptor(i).getLocalName();
            if (autoincrementColumns.contains(attName)) continue;
            this.queryData.write(i, currAtt);
        }
        this.queryData.doInsert();
        if (mapper.getColumnCount() > 0 && mapper.hasAutoIncrementColumns()) {
            this.fidAttributes = new Object[mapper.getColumnCount()];
            for (i = 0; i < this.fidAttributes.length; ++i) {
                this.fidAttributes[i] = this.queryData.readFidColumn(i);
            }
            mutable.setID(mapper.getID(this.fidAttributes));
        }
    }

    public boolean hasNext() throws IOException {
        if (this.queryData.isClosed()) {
            throw new IOException("Feature writer is closed");
        }
        return this.reader.hasNext();
    }

    public void close() throws IOException {
        if (this.queryData.isClosed()) {
            LOGGER.warning("Feature writer calling close when queryData is  already closed");
        } else {
            this.reader.close();
        }
    }

    protected String encodeName(String tableName) {
        return tableName;
    }

    protected String encodeColumnName(String colName) {
        return this.encodeName(colName);
    }
}

