/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.util.ImagingException;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverageio.jp2k.Granule;
import org.geotools.coverageio.jp2k.RasterLayerRequest;
import org.geotools.coverageio.jp2k.RasterManager;
import org.geotools.coverageio.jp2k.Utils;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

class RasterLayerResponse {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerResponse.class);
    private GridCoverage2D gridCoverage;
    private RasterLayerRequest request;
    private GridCoverageFactory coverageFactory;
    private GeneralEnvelope coverageEnvelope;
    private URL inputURL;
    private boolean frozen = false;
    private RasterManager rasterManager;
    private Color transparentColor;
    private RenderedImage theImage;
    private ReferencedEnvelope bbox;
    private Rectangle rasterBounds;
    private MathTransform2D finalGridToWorldCorner;
    private MathTransform2D finalWorldToGridCorner;
    private int imageChoice = 0;
    private ImageReadParam baseReadParameters = new ImageReadParam();
    private boolean alphaIn = false;
    private String location;
    private MathTransform baseGridToWorld;

    public RasterLayerResponse(RasterLayerRequest request, RasterManager rasterManager) {
        this.request = request;
        this.inputURL = rasterManager.getInputURL();
        File tempFile = null;
        try {
            if (!this.inputURL.getProtocol().equalsIgnoreCase("file")) {
                throw new IllegalArgumentException("unsupported input:" + this.inputURL.toString());
            }
            tempFile = new File(URLDecoder.decode(this.inputURL.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        this.location = tempFile.getAbsolutePath();
        this.coverageEnvelope = rasterManager.getCoverageEnvelope();
        this.coverageFactory = rasterManager.getCoverageFactory();
        this.rasterManager = rasterManager;
        this.baseGridToWorld = rasterManager.getRaster2Model();
        this.transparentColor = request.getInputTransparentColor();
    }

    public GridCoverage2D createResponse() throws IOException {
        this.processRequest();
        return this.gridCoverage;
    }

    public RasterLayerRequest getOriginatingCoverageRequest() {
        return this.request;
    }

    private synchronized void processRequest() throws IOException {
        if (this.request.isEmpty()) {
            throw new IOException("Empty request " + this.request.toString());
        }
        if (this.frozen) {
            return;
        }
        RenderedImage image = this.assembleGranules();
        RenderedImage finalRaster = this.postProcessRaster(image);
        this.gridCoverage = this.prepareCoverage(finalRaster);
        this.frozen = true;
    }

    private RenderedImage assembleGranules() throws DataSourceException {
        try {
            BoundingBox cropBBOX;
            this.imageChoice = this.request.getRequestedBBox() != null && this.request.getRequestedRasterArea() != null ? this.setReadParams(this.request.getOverviewPolicy(), this.baseReadParameters, this.request) : 0;
            assert (this.imageChoice >= 0);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("Loading level ").append(this.imageChoice).append(" with subsampling factors ").append(this.baseReadParameters.getSourceXSubsampling()).append(" ").append(this.baseReadParameters.getSourceYSubsampling()).toString());
            }
            this.bbox = (cropBBOX = this.request.getCropBBox()) != null ? ReferencedEnvelope.reference((BoundingBox)cropBBOX) : new ReferencedEnvelope((Envelope)this.coverageEnvelope);
            AffineTransform g2w = new AffineTransform((AffineTransform)this.baseGridToWorld);
            g2w.concatenate(Utils.CENTER_TO_CORNER);
            RasterManager.OverviewLevel level = this.rasterManager.overviewsController.resolutionsLevels.get(this.imageChoice);
            RasterManager.OverviewLevel baseLevel = this.rasterManager.overviewsController.resolutionsLevels.get(0);
            AffineTransform2D adjustments = new AffineTransform2D(level.resolutionX / baseLevel.resolutionX * (double)this.baseReadParameters.getSourceXSubsampling(), 0.0, 0.0, level.resolutionY / baseLevel.resolutionY * (double)this.baseReadParameters.getSourceYSubsampling(), 0.0, 0.0);
            g2w.concatenate((AffineTransform)adjustments);
            this.finalGridToWorldCorner = new AffineTransform2D(g2w);
            this.finalWorldToGridCorner = this.finalGridToWorldCorner.inverse();
            this.rasterBounds = new GeneralGridEnvelope((Envelope)CRS.transform((MathTransform)this.finalWorldToGridCorner, (Envelope)this.bbox), PixelInCell.CELL_CORNER, false).toRectangle();
            GranuleWorker worker = new GranuleWorker();
            worker.init(new ReferencedEnvelope((Envelope)this.coverageEnvelope));
            worker.produce();
            if (worker.granulesNumber >= 1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Loaded bbox " + this.bbox.toString() + " while crop bbox " + this.request.getCropBBox().toString());
                }
                return this.theImage;
            }
            return ConstantDescriptor.create((Float)Float.valueOf(this.rasterBounds.width), (Float)Float.valueOf(this.rasterBounds.height), (Number[])new Byte[]{(byte)0}, (RenderingHints)this.rasterManager.getHints());
        }
        catch (IOException e) {
            throw new DataSourceException("Unable to create this image", (Throwable)e);
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to create this image", (Throwable)e);
        }
    }

    private RenderedImage processGranuleRaster(RenderedImage granule, int granuleIndex, boolean alphaIn, boolean doTransparentColor, Color transparentColor) {
        if (this.rasterManager.expandMe && granule.getColorModel() instanceof IndexColorModel) {
            granule = new ImageWorker(granule).forceComponentColorModel().getRenderedImage();
        }
        if (doTransparentColor) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on input image number " + granuleIndex);
            }
            granule = ImageUtilities.maskColor((Color)transparentColor, (RenderedImage)granule);
        }
        return granule;
    }

    private GridCoverage2D prepareCoverage(RenderedImage image) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        int i = 0;
        while (i < numBands) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            bands[i] = new GridSampleDimension((CharSequence)colorInterpretation.name()).geophysics(true);
            ++i;
        }
        return this.coverageFactory.create((CharSequence)this.rasterManager.getCoverageIdentifier(), image, (Envelope)new GeneralEnvelope((Envelope)this.bbox), bands, null, null);
    }

    private int setReadParams(OverviewPolicy overviewPolicy, ImageReadParam readParams, RasterLayerRequest request) throws IOException, TransformException {
        int imageChoice = 0;
        readParams.setSourceSubsampling(1, 1, 0, 0);
        OverviewPolicy policy = overviewPolicy == null ? this.rasterManager.overviewPolicy : overviewPolicy;
        if (policy.equals((Object)OverviewPolicy.IGNORE)) {
            return imageChoice;
        }
        imageChoice = this.rasterManager.overviewsController.pickOverviewLevel(overviewPolicy, request);
        this.rasterManager.decimationController.performDecimation(imageChoice, readParams, request);
        return imageChoice;
    }

    private RenderedImage postProcessRaster(RenderedImage image) {
        if (this.transparentColor != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on final image");
            }
            ImageWorker w = new ImageWorker(image);
            if (image.getSampleModel() instanceof MultiPixelPackedSampleModel) {
                w.forceComponentColorModel();
            }
            return w.makeColorTransparent(this.transparentColor).getRenderedImage();
        }
        return image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GranuleLoader
    implements Callable<RenderedImage> {
        final ReferencedEnvelope cropBBox;
        final MathTransform2D worldToGrid;
        final Granule granule;
        final ImageReadParam readParameters;
        final int imageIndex;
        final Dimension tilesDimension;

        GranuleLoader(ImageReadParam readParameters, int imageIndex, ReferencedEnvelope cropBBox, MathTransform2D worldToGrid, Granule granule, Dimension tilesDimension) {
            this.readParameters = Utils.cloneImageReadParam(readParameters);
            this.imageIndex = imageIndex;
            this.cropBBox = cropBBox;
            this.worldToGrid = worldToGrid;
            this.granule = granule;
            this.tilesDimension = tilesDimension != null ? (Dimension)tilesDimension.clone() : null;
        }

        public BoundingBox getCropBBox() {
            return this.cropBBox;
        }

        public MathTransform2D getWorldToGrid() {
            return this.worldToGrid;
        }

        public Granule getGranule() {
            return this.granule;
        }

        public ImageReadParam getReadParameters() {
            return this.readParameters;
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        @Override
        public RenderedImage call() throws Exception {
            return this.granule.loadRaster(this.readParameters, this.imageIndex, this.cropBBox, this.worldToGrid, RasterLayerResponse.this.request, this.tilesDimension);
        }
    }

    class GranuleWorker {
        private final List<Future<RenderedImage>> tasks = new ArrayList<Future<RenderedImage>>();
        private int granulesNumber;
        private boolean doInputTransparency;
        private Color inputTransparentColor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(ReferencedEnvelope aoi) {
            File rasterFile;
            ReferencedEnvelope granuleBBox = aoi;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("About to read image number " + this.granulesNumber);
            }
            if ((rasterFile = new File(RasterLayerResponse.this.location)) == null) {
                // empty if block
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("File found " + RasterLayerResponse.this.location);
            }
            Granule granule = null;
            SoftValueHashMap<String, Granule> softValueHashMap = ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache;
            synchronized (softValueHashMap) {
                if (((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache.containsKey((Object)rasterFile.toURI().toString())) {
                    granule = (Granule)((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache.get((Object)rasterFile.toURI().toString());
                } else {
                    granule = new Granule((BoundingBox)granuleBBox, rasterFile);
                    ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.granulesCache.put((Object)rasterFile.toURI().toString(), (Object)granule);
                }
            }
            GranuleLoader loader = new GranuleLoader(RasterLayerResponse.this.baseReadParameters, RasterLayerResponse.this.imageChoice, RasterLayerResponse.this.bbox, RasterLayerResponse.this.finalWorldToGridCorner, granule, RasterLayerResponse.this.request.getTileDimensions());
            this.tasks.add(new FutureTask<RenderedImage>(loader));
            ++this.granulesNumber;
        }

        public void produce() {
            int granuleIndex = 0;
            this.inputTransparentColor = RasterLayerResponse.this.request.getInputTransparentColor();
            this.doInputTransparency = this.inputTransparentColor != null;
            boolean firstGranule = true;
            for (Future<RenderedImage> future : this.tasks) {
                RenderedImage loadedImage;
                block10: {
                    try {
                        FutureTask task = (FutureTask)future;
                        task.run();
                        loadedImage = future.get();
                        if (loadedImage == null) {
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.log(Level.FINE, "Unable to load the raster for granule " + granuleIndex + " with request " + RasterLayerResponse.this.request.toString());
                            continue;
                        }
                        if (!firstGranule) break block10;
                        ColorModel cm = loadedImage.getColorModel();
                        RasterLayerResponse.this.alphaIn = cm.hasAlpha();
                        firstGranule = false;
                    }
                    catch (InterruptedException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Unable to load the raster for granule " + granuleIndex, e);
                        continue;
                    }
                    catch (ExecutionException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, "Unable to load the raster for granule " + granuleIndex, e);
                        continue;
                    }
                    catch (com.sun.media.jai.codecimpl.util.ImagingException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Loading image number " + granuleIndex + " failed, original request was " + RasterLayerResponse.this.request);
                        continue;
                    }
                    catch (ImagingException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Loading image number " + granuleIndex + " failed, original request was " + RasterLayerResponse.this.request);
                        continue;
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Loading image number " + granuleIndex);
                }
                RenderedImage raster = RasterLayerResponse.this.processGranuleRaster(loadedImage, granuleIndex, RasterLayerResponse.this.alphaIn, this.doInputTransparency, this.inputTransparentColor);
                RasterLayerResponse.this.theImage = raster;
                ++granuleIndex;
            }
            this.granulesNumber = granuleIndex;
            if (this.granulesNumber == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load any data ");
                }
                return;
            }
        }
    }
}

