/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverageio.jp2k.Utils;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ReadType {
    DIRECT_READ{

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        RenderedImage read(ImageReadParam readP, int imageIndex, File rasterFile, Rectangle readDimension, Dimension tileDimension, ImageReaderSpi spi) throws IOException {
            ImageInputStream inStream = null;
            ImageReader reader = null;
            try {
                inStream = Utils.getInputStream(rasterFile);
                if (inStream == null) {
                    return null;
                }
                reader = spi.createReaderInstance();
                if (reader == null) {
                    if (!LOGGER.isLoggable(Level.WARNING)) return null;
                    LOGGER.warning("Unable to get reader for file " + rasterFile.getAbsolutePath());
                    return null;
                }
                inStream.reset();
                reader.setInput(inStream);
                if (CoverageUtilities.checkEmptySourceRegion((ImageReadParam)readP, (Rectangle)readDimension)) {
                    return null;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "reading file: " + rasterFile.getAbsolutePath());
                }
                BufferedImage bufferedImage = reader.read(imageIndex, readP);
                return bufferedImage;
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) return null;
                LOGGER.log(Level.WARNING, "Unable to compute source area for file " + rasterFile.getAbsolutePath(), e);
                return null;
            }
            finally {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
                try {
                    inStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
    ,
    JAI_IMAGEREAD{

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        RenderedImage read(ImageReadParam readP, int imageIndex, File rasterFile, Rectangle readDimension, Dimension tileDimension, ImageReaderSpi spi) throws IOException {
            RenderedOp raster;
            ImageReader reader;
            ImageInputStream inStream;
            block32: {
                inStream = null;
                reader = null;
                inStream = Utils.getInputStream(rasterFile);
                if (inStream != null) break block32;
                return null;
            }
            try {
                try {
                    reader = spi.createReaderInstance();
                    if (reader == null) {
                        if (!LOGGER.isLoggable(Level.WARNING)) return null;
                        LOGGER.warning("Unable to get reader for file " + rasterFile.getAbsolutePath());
                        return null;
                    }
                    inStream.reset();
                    reader.setInput(inStream);
                    if (CoverageUtilities.checkEmptySourceRegion((ImageReadParam)readP, (Rectangle)readDimension)) {
                        return null;
                    }
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Unable to compute source area for file " + rasterFile.getAbsolutePath(), e);
                    }
                    try {
                        if (reader != null) {
                            reader.dispose();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        if (inStream == null) return null;
                        inStream.close();
                        return null;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return null;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            ParameterBlock pbjImageRead = new ParameterBlock();
            pbjImageRead.add(rasterFile);
            pbjImageRead.add(imageIndex);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(null);
            pbjImageRead.add(null);
            pbjImageRead.add(readP);
            pbjImageRead.add(spi.createReaderInstance());
            if (tileDimension != null) {
                ImageLayout layout = new ImageLayout();
                layout.setTileWidth(tileDimension.width).setTileHeight(tileDimension.height);
                raster = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            } else {
                raster = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead);
            }
            if (raster == null) return raster;
            raster.getWidth();
            return raster;
        }
    }
    ,
    JAI_IMAGEREAD_MT{

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        RenderedImage read(ImageReadParam readP, int imageIndex, File rasterFile, Rectangle readDimension, Dimension tileDimension, ImageReaderSpi spi) throws IOException {
            RenderedOp raster;
            ImageReader reader;
            ImageInputStream inStream;
            block32: {
                inStream = null;
                reader = null;
                inStream = Utils.getInputStream(rasterFile);
                if (inStream != null) break block32;
                return null;
            }
            try {
                try {
                    reader = spi.createReaderInstance();
                    if (reader == null) {
                        if (!LOGGER.isLoggable(Level.WARNING)) return null;
                        LOGGER.warning("Unable to get reader for file " + rasterFile.getAbsolutePath());
                        return null;
                    }
                    inStream.reset();
                    reader.setInput(inStream);
                    if (CoverageUtilities.checkEmptySourceRegion((ImageReadParam)readP, (Rectangle)readDimension)) {
                        return null;
                    }
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Unable to compute source area for file " + rasterFile.getAbsolutePath(), e);
                    }
                    try {
                        if (reader != null) {
                            reader.dispose();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        if (inStream == null) return null;
                        inStream.close();
                        return null;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return null;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            ParameterBlock pbjImageRead = new ParameterBlock();
            pbjImageRead.add(rasterFile);
            pbjImageRead.add(imageIndex);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(false);
            pbjImageRead.add(null);
            pbjImageRead.add(null);
            pbjImageRead.add(readP);
            pbjImageRead.add(spi.createReaderInstance());
            if (tileDimension != null) {
                ImageLayout layout = new ImageLayout();
                layout.setTileWidth(tileDimension.width).setTileHeight(tileDimension.height);
                raster = JAI.create((String)"ImageReadMT", (ParameterBlock)pbjImageRead, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            } else {
                raster = JAI.create((String)"ImageReadMT", (ParameterBlock)pbjImageRead);
            }
            if (raster == null) return raster;
            raster.getWidth();
            return raster;
        }
    }
    ,
    UNSPECIFIED{

        RenderedImage read(ImageReadParam readP, int imageIndex, File rasterFile, Rectangle readDimension, Dimension tileDimension, ImageReaderSpi spi) throws IOException {
            throw new UnsupportedOperationException(Errors.format((int)205, (Object)"read"));
        }
    };

    private static final Logger LOGGER;

    static {
        LOGGER = Logging.getLogger(ReadType.class);
    }

    private ReadType() {
    }

    static ReadType getDefault() {
        return JAI_IMAGEREAD;
    }

    abstract RenderedImage read(ImageReadParam var1, int var2, File var3, Rectangle var4, Dimension var5, ImageReaderSpi var6) throws IOException;

    /* synthetic */ ReadType(String string, int n, ReadType readType) {
        this();
    }
}

