/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverageio.jp2k.JP2KReader;
import org.geotools.coverageio.jp2k.Utils;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class JP2KFormat
extends AbstractGridFormat
implements Format {
    private ImageReaderSpi spi = null;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverageio.jp2k");
    private static final String USE_MT = "USE_MULTITHREADING";
    public static final DefaultParameterDescriptor<Boolean> USE_MULTITHREADING = new DefaultParameterDescriptor("USE_MULTITHREADING", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);

    public JP2KFormat() {
        this.setInfo();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new JP2KFormat.");
        }
    }

    protected void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "JP2K (Direct) ");
        info.put("description", "JP2K (Direct) Coverage Format");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.writeParameters = null;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, USE_JAI_IMAGEREAD, USE_MULTITHREADING, SUGGESTED_TILE_SIZE}));
    }

    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        try {
            return new JP2KReader(source, hints);
        }
        catch (MismatchedDimensionException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing at this time.");
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("This plugin does not support writing parameters");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("This plugin does not support writing at this time.");
    }

    public boolean accepts(Object input, Hints hints) {
        try {
            File directory;
            if (input != null && input instanceof File && (!(directory = (File)input).exists() || directory.isDirectory())) {
                return false;
            }
            ImageInputStream stream = ImageIO.createImageInputStream(input);
            if (this.spi == null) {
                ImageReader reader = Utils.getReader(stream);
                if (reader != null) {
                    this.spi = reader.getOriginatingProvider();
                } else {
                    return false;
                }
            }
            return this.spi.canDecodeInput(stream);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return false;
        }
    }
}

