/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.type.FeatureAttributeType;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.feature.type.NumericAttributeType;
import org.geotools.feature.type.TemporalAttributeType;
import org.geotools.feature.type.TextualAttributeType;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LengthFunction;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultAttributeTypeFactory
extends AttributeTypeFactory {
    private FilterFactory ff;

    public DefaultAttributeTypeFactory() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public DefaultAttributeTypeFactory(FilterFactory factory) {
        this.ff = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = factory;
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength) {
        return this.createAttributeType(name, clazz, isNillable, fieldLength, null);
    }

    protected AttributeType createAttributeType(String name, FeatureType type, boolean isNillable) {
        return new FeatureAttributeType(name, type, isNillable, this.minOccurs(isNillable), 1);
    }

    protected Filter length(int fieldLength, String attributeXPath) {
        if (fieldLength < 0) {
            return null;
        }
        LengthFunction length = (LengthFunction)this.ff.function("LengthFunction", new Expression[]{this.ff.property(attributeXPath)});
        if (length == null) {
            return null;
        }
        PropertyIsLessThanOrEqualTo cf = null;
        try {
            cf = this.ff.lessOrEqual((Expression)length, (Expression)this.ff.literal(fieldLength));
        }
        catch (IllegalFilterException e) {
            // empty catch block
        }
        return cf == null ? Filter.EXCLUDE : cf;
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength, Object defaultValue) {
        Filter f = this.length(fieldLength, name);
        int minOccurs = this.minOccurs(isNillable);
        int maxOccurs = 1;
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumericAttributeType(name, clazz, isNillable, minOccurs, maxOccurs, defaultValue, f);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return new TextualAttributeType(name, isNillable, minOccurs, maxOccurs, defaultValue, f);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new TemporalAttributeType(name, clazz, isNillable, minOccurs, maxOccurs, defaultValue, f);
        }
        if (Geometry.class.isAssignableFrom(clazz)) {
            return new GeometricAttributeType(name, clazz, isNillable, minOccurs, maxOccurs, defaultValue, null, f);
        }
        return new DefaultAttributeType(name, clazz, isNillable, minOccurs, maxOccurs, defaultValue, f);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, Filter filter, Object defaultValue, Object metadata) {
        return this.createAttributeType(name, clazz, isNillable, filter, defaultValue, metadata, this.minOccurs(isNillable), 1);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, Filter filter, Object defaultValue, Object metadata, int min, int max) {
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumericAttributeType(name, clazz, isNillable, min, max, defaultValue, filter);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return new TextualAttributeType(name, isNillable, min, max, defaultValue, filter);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new TemporalAttributeType(name, clazz, isNillable, min, max, defaultValue, filter);
        }
        if (Geometry.class.isAssignableFrom(clazz)) {
            if (metadata instanceof CoordinateReferenceSystem) {
                return new GeometricAttributeType(name, clazz, isNillable, min, max, defaultValue, (CoordinateReferenceSystem)metadata, filter);
            }
            return new GeometricAttributeType(name, clazz, isNillable, min, max, defaultValue, null, filter);
        }
        return new DefaultAttributeType(name, clazz, isNillable, min, max, defaultValue, filter);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength, Object defaultValue, Object metaData) {
        if (Geometry.class.isAssignableFrom(clazz) && metaData instanceof CoordinateReferenceSystem) {
            Filter f = this.length(fieldLength, name);
            return new GeometricAttributeType(name, clazz, isNillable, this.minOccurs(isNillable), 1, defaultValue, (CoordinateReferenceSystem)metaData, f);
        }
        return this.createAttributeType(name, clazz, isNillable, fieldLength, defaultValue);
    }

    private int minOccurs(boolean nillable) {
        return nillable ? 0 : 1;
    }
}

