/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.feature.type.DefaultFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.identity.FeatureId;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFeature
extends SimpleFeatureImpl
implements SimpleFeature,
Cloneable {
    private FeatureCollection<SimpleFeatureType, org.opengis.feature.simple.SimpleFeature> parent;

    protected DefaultFeature(DefaultFeatureType schema, Object[] attributes, String featureID) throws IllegalAttributeException, NullPointerException {
        super(DefaultFeature.wrapValues(attributes, schema), (SimpleFeatureType)schema, (FeatureId)SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)featureID));
        if (schema == null) {
            throw new NullPointerException("schema");
        }
    }

    static List wrapValues(Object[] values, DefaultFeatureType schema) {
        ArrayList<1> atts = new ArrayList<1>(values.length);
        for (int i = 0; i < values.length; ++i) {
            atts.add(new AttributeImpl(values[i], schema.getDescriptor(i), null){

                public void set(Object newValue) throws IllegalArgumentException, IllegalStateException {
                    this.value = newValue = this.parse(newValue);
                }
            });
        }
        return atts;
    }

    protected DefaultFeature(DefaultFeatureType schema, Object[] attributes) throws IllegalAttributeException {
        this(schema, attributes, null);
    }

    public DefaultFeature(List attributes, DefaultFeatureType schema, String id) {
        super(attributes, (SimpleFeatureType)schema, (FeatureId)SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)id));
    }

    String defaultID() {
        return "fid-" + new UID().toString().replace(':', '_');
    }

    @Override
    public FeatureType getFeatureType() {
        return (FeatureType)this.getType();
    }

    @Override
    public Object[] getAttributes(Object[] array) {
        List values = this.getAttributes();
        Object[] retArray = array == null ? new Object[values.size()] : array;
        return values.toArray(retArray);
    }

    @Override
    public void setAttribute(int position, Object val) {
        try {
            super.setAttribute(position, val);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw ioobe;
        }
        catch (Exception e) {
            throw (IllegalAttributeException)new IllegalAttributeException(e.getLocalizedMessage()).initCause((Throwable)e);
        }
    }

    @Override
    public void setAttributes(Object[] attributes) throws IllegalAttributeException {
        try {
            super.setAttributes(attributes);
        }
        catch (Exception e) {
            throw (IllegalAttributeException)new IllegalAttributeException(e.getLocalizedMessage()).initCause((Throwable)e);
        }
    }

    @Override
    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        try {
            super.setAttribute(xPath, attribute);
        }
        catch (Exception e) {
            throw (IllegalAttributeException)new IllegalAttributeException(e.getLocalizedMessage()).initCause((Throwable)e);
        }
    }

    @Override
    public Geometry getDefaultGeometry() {
        return (Geometry)super.getDefaultGeometry();
    }

    @Override
    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        try {
            super.setDefaultGeometry((Object)geometry);
        }
        catch (Exception e) {
            throw (IllegalAttributeException)new IllegalAttributeException(e.getLocalizedMessage()).initCause((Throwable)e);
        }
    }

    @Override
    public int getNumberOfAttributes() {
        return this.getAttributeCount();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return (ReferencedEnvelope)super.getBounds();
    }

    public Object clone() {
        try {
            DefaultFeature clone = (DefaultFeature)super.clone();
            clone.setValue(this.getValue());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("The impossible has happened", e);
        }
    }

    public String toString() {
        String retString = "Feature[ id=" + this.getID() + " , ";
        FeatureType featType = this.getFeatureType();
        List attributes = this.getAttributes();
        int n = attributes.size();
        for (int i = 0; i < n; ++i) {
            retString = retString + featType.getAttributeType(i).getLocalName() + "=";
            retString = retString + attributes.get(i);
            if (i + 1 >= n) continue;
            retString = retString + " , ";
        }
        retString = retString + " ]";
        return retString;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Feature)) {
            return false;
        }
        return super.equals(obj);
    }

    public FeatureCollection<SimpleFeatureType, org.opengis.feature.simple.SimpleFeature> getParent() {
        return this.parent;
    }

    public void setParent(FeatureCollection<SimpleFeatureType, org.opengis.feature.simple.SimpleFeature> collection) {
        if (this.parent == null) {
            this.parent = collection;
        }
    }

    public Feature toComplex() {
        try {
            return new ComplexWrapper(this);
        }
        catch (IllegalAttributeException iae) {
            throw new RuntimeException("the impossible has happened: ", iae);
        }
    }

    static final class ComplexWrapper
    extends DefaultFeature {
        private ComplexWrapper(DefaultFeatureType fType, Object[] atts, String fid) throws IllegalAttributeException {
            super(ComplexWrapper.wrapValuesComplex(atts, ComplexWrapper.makeComplex(fType)), ComplexWrapper.makeComplex(fType), fid);
        }

        public ComplexWrapper(DefaultFeatureType fType, Object[] atts) throws IllegalAttributeException {
            this(fType, atts, null);
        }

        public ComplexWrapper(SimpleFeature feature) throws IllegalAttributeException {
            this((DefaultFeatureType)feature.getFeatureType(), feature.getAttributes(null), feature.getID());
        }

        public void setAttribute(int index, Object value) {
            this.checkList(value);
            List valList = (List)value;
            int listSize = valList.size();
            if (listSize == 0) {
                super.setAttribute(index, (Object)ComplexWrapper.wrapInList(null));
            } else {
                AttributeType type = super.getFeatureType().getAttributeType(index);
                Object val = valList.get(0);
                try {
                    Object parsed = type.parse(val);
                    type.validate(parsed);
                    super.setAttribute(index, (Object)ComplexWrapper.wrapInList(parsed));
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalAttributeException((AttributeDescriptor)type, val, (Throwable)iae);
                }
            }
        }

        private void checkList(Object value) throws IllegalAttributeException {
            if (value instanceof List) {
                List valList = (List)value;
                int listSize = valList.size();
                if (listSize > 1) {
                    String errMsg = "The attribute: " + valList + " has more " + "attributes (" + listSize + ") than is allowed by an " + " attributeType in a Simple Feature (1)";
                    throw new IllegalAttributeException(errMsg);
                }
            } else {
                String errMsg = "All objects set in a ComplexFeature must be Lists, to account for multiplicity";
                throw new IllegalAttributeException(errMsg);
            }
        }

        public void setAttribute(String xPath, Object attribute) {
            int idx = super.getFeatureType().find(xPath);
            if (idx < 0) {
                throw new IllegalAttributeException("No attribute named " + xPath);
            }
            this.setAttribute(idx, attribute);
        }

        static List wrapValuesComplex(Object[] values, DefaultFeatureType schema) {
            ArrayList<1> atts = new ArrayList<1>(values.length);
            for (int i = 0; i < values.length; ++i) {
                atts.add(new AttributeImpl(ComplexWrapper.wrapInList(values[i]), schema.getDescriptor(i), null){

                    public void setValue(Object newValue) throws IllegalArgumentException, IllegalStateException {
                        this.value = newValue = this.parse(newValue);
                    }

                    protected Object parse(Object value) throws IllegalArgumentException {
                        return value;
                    }
                });
            }
            return atts;
        }

        protected static List wrapInList(Object attribute) {
            return Collections.singletonList(attribute);
        }

        protected static Object[] wrapInList(Object[] attributes, int defaultSize) {
            Object[] retArray = attributes;
            retArray = attributes == null ? new Object[defaultSize] : attributes;
            for (int i = 0; i < attributes.length; ++i) {
                retArray[i] = ComplexWrapper.wrapInList(attributes[i]);
            }
            return retArray;
        }

        protected static DefaultFeatureType makeComplex(DefaultFeatureType original) {
            DefaultFeatureTypeBuilder builder = new DefaultFeatureTypeBuilder(){

                protected AttributeDescriptor createAttributeDescriptor(String name, final Class binding) {
                    return new DefaultAttributeType(name, List.class, true, 1, 1, null, null){

                        public void validate(Object attribute) throws IllegalArgumentException {
                            if (!binding.isAssignableFrom(attribute.getClass())) {
                                throw new IllegalArgumentException();
                            }
                        }
                    };
                }
            };
            builder.setName(original.getName().getLocalPart());
            builder.setNamespaceURI(original.getName().getNamespaceURI());
            for (int i = 0; i < original.getAttributeCount(); ++i) {
                AttributeType attributeType = original.getAttributeType(i);
                builder.add(attributeType.getLocalName(), attributeType.getBinding());
            }
            return builder.buildFeatureType();
        }
    }
}

