/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.awt.RenderingHints;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.DefaultFeatureTypeFactory;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;

public abstract class FeatureTypeBuilder
extends FeatureTypes
implements Factory {
    public static final FeatureType ABSTRACT_FEATURE_TYPE;
    private static boolean initialized;
    private String name;
    private URI namespace;
    private boolean dirty = true;
    private FeatureType type = null;
    private GeometryAttributeType defaultGeometry = null;
    private boolean abstractType = false;
    private Set superTypes;
    Map hints;

    public FeatureTypeBuilder() {
        this(Collections.EMPTY_MAP);
    }

    public FeatureTypeBuilder(Map hints) {
        this.hints = hints;
    }

    public Map getImplementationHints() {
        return this.hints;
    }

    public static FeatureTypeFactory newInstance(String typeName) throws FactoryRegistryException {
        Hints hints = GeoTools.getDefaultHints();
        if (hints == null) {
            hints = new Hints((RenderingHints.Key)Hints.FEATURE_TYPE_FACTORY_NAME, (Object)typeName);
        } else {
            hints.put((Object)Hints.FEATURE_TYPE_FACTORY_NAME, (Object)typeName);
        }
        hints.put((Object)Hints.FEATURE_TYPE_FACTORY_NAME, (Object)typeName);
        return new DefaultFeatureTypeFactory();
    }

    public void importType(FeatureType type, boolean strict) throws IllegalArgumentException {
        int ii = type.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            try {
                this.addType(type.getAttributeType(i));
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (!strict) continue;
                throw iae;
            }
        }
    }

    public final void setSuperTypes(Collection types) {
        this.superTypes = new LinkedHashSet(types);
    }

    public final Collection getSuperTypes() {
        Set<FeatureType> supers = this.superTypes == null ? new HashSet() : this.superTypes;
        boolean add = true;
        for (FeatureType superType : supers) {
            if (!superType.isDescendedFrom(ABSTRACT_FEATURE_TYPE)) continue;
            add = false;
        }
        if (add) {
            supers.add(ABSTRACT_FEATURE_TYPE);
        }
        return supers;
    }

    public void importType(FeatureType type) {
        this.importType(type, false);
    }

    public void setName(String name) {
        this.dirty |= this.isDifferent(name, this.name);
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public void setNamespace(URI namespace) {
        this.dirty |= this.isDifferent(namespace, this.namespace);
        this.namespace = namespace;
    }

    public final URI getNamespace() {
        return this.namespace;
    }

    public final boolean isAbstract() {
        return this.abstractType;
    }

    public final void setAbstract(boolean a) {
        this.dirty = true;
        this.abstractType = a;
    }

    private boolean isDifferent(String s1, String s2) {
        if (s1 != null) {
            return !s1.equals(s2);
        }
        if (s2 != null) {
            return !s2.equals(s1);
        }
        return s1 != s2;
    }

    private boolean isDifferent(URI u1, URI u2) {
        if (u1 != null) {
            return !u1.equals(u2);
        }
        if (u2 != null) {
            return !u2.equals(u1);
        }
        return u1 != u2;
    }

    public final void removeAll() {
        int cnt;
        for (int i = cnt = this.getAttributeCount(); i > 0; ++i) {
            this.removeType(i - 1);
        }
    }

    public final void addTypes(AttributeType[] types) throws NullPointerException, IllegalArgumentException {
        if (types == null) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            this.addType(types[i]);
        }
    }

    public final void addType(AttributeType type) throws NullPointerException, IllegalArgumentException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.dirty = true;
        this.check(type);
        this.add(type);
    }

    public final void removeType(AttributeType type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.dirty = true;
        AttributeType removed = this.remove(type);
        if (removed == this.defaultGeometry) {
            this.defaultGeometry = null;
        }
    }

    public final void addType(int idx, AttributeType type) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.dirty = true;
        this.check(type);
        this.add(idx, type);
    }

    public final void removeType(int idx) throws ArrayIndexOutOfBoundsException {
        this.dirty = true;
        AttributeType removed = this.remove(idx);
        if (removed == this.defaultGeometry) {
            this.defaultGeometry = null;
        }
    }

    public final void setType(int idx, AttributeType type) throws IllegalArgumentException, NullPointerException, ArrayIndexOutOfBoundsException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.dirty = true;
        this.check(type);
        AttributeType removed = this.set(idx, type);
        if (removed == this.defaultGeometry) {
            this.defaultGeometry = null;
        }
    }

    public final void swap(int idx1, int idx2) throws ArrayIndexOutOfBoundsException {
        AttributeType tmp = this.get(idx1);
        this.set(idx1, this.get(idx2));
        this.set(idx2, tmp);
        this.dirty = true;
    }

    public final GeometryAttributeType getDefaultGeometry() {
        return this.defaultGeometry;
    }

    public final void setDefaultGeometry(GeometryAttributeType defaultGeometry) throws IllegalArgumentException {
        if (defaultGeometry != null && !defaultGeometry.isGeometry()) {
            String mess = "Attempted to set a non-geometry type as defaultGeometry: ";
            throw new IllegalArgumentException(mess + defaultGeometry);
        }
        this.dirty = true;
        this.defaultGeometry = defaultGeometry;
        if (defaultGeometry != null && !this.contains(defaultGeometry)) {
            this.addType(defaultGeometry);
        }
    }

    public final FeatureType getFeatureType() throws SchemaException {
        if (this.dirty || this.type == null) {
            if (this.defaultGeometry == null) {
                int ii = this.getAttributeCount();
                for (int i = 0; i < ii; ++i) {
                    if (!(this.get(i) instanceof GeometryAttributeType)) continue;
                    this.defaultGeometry = (GeometryAttributeType)this.get(i);
                    break;
                }
            }
            if (this.name == null || this.name.trim().length() == 0) {
                throw new SchemaException("Cannot create FeatureType with null or blank name");
            }
            this.type = this.createFeatureType();
            if (this.type == null) {
                throw new NullPointerException(((Object)((Object)this)).getClass().getName() + ".createFeatureType()");
            }
            if (this.isAbstract() && !this.type.isAbstract()) {
                throw new RuntimeException("FeatureTypeFactory poorly implemented, expected abstract type, received " + this.type);
            }
            this.dirty = false;
        }
        return this.type;
    }

    public String toString() {
        String types = "";
        int ii = this.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            types = types + this.get(i);
            if (i >= ii) continue;
            types = types + " , ";
        }
        return "FeatureTypeFactory(" + ((Object)((Object)this)).getClass().getName() + ") [ " + types + " ]";
    }

    public final boolean contains(AttributeType type) {
        int ii = this.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            if (!this.get(i).getLocalName().equals(type.getLocalName())) continue;
            return true;
        }
        return false;
    }

    protected void check(AttributeType type) {
        if (this.contains(type)) {
            throw new IllegalArgumentException("Duplicate AttributeTypes " + type);
        }
    }

    protected void addBaseTypes(Set types) {
    }

    protected abstract FeatureType createFeatureType() throws SchemaException;

    protected abstract void add(AttributeType var1) throws IllegalArgumentException;

    protected abstract AttributeType remove(AttributeType var1);

    protected abstract void add(int var1, AttributeType var2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException;

    protected abstract AttributeType remove(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract AttributeType get(int var1) throws ArrayIndexOutOfBoundsException;

    protected abstract AttributeType set(int var1, AttributeType var2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException;

    public abstract int getAttributeCount();

    static {
        DefaultFeatureType featureType = null;
        try {
            featureType = new DefaultFeatureType("Feature", new URI("http://www.opengis.net/gml"), null, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ABSTRACT_FEATURE_TYPE = featureType;
    }
}

