/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.ParamDescriptor;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataStoreFactory
implements DataStoreFactorySpi {
    public String getDisplayName() {
        String name = this.getClass().getName();
        if ((name = name.substring(name.lastIndexOf(46))).endsWith("Factory")) {
            name = name.substring(0, name.length() - 7);
        } else if (name.endsWith("FactorySpi")) {
            name = name.substring(0, name.length() - 10);
        }
        return name;
    }

    public boolean canProcess(Map params) {
        if (params == null) {
            return false;
        }
        DataAccessFactory.Param[] arrayParameters = this.getParametersInfo();
        int i = 0;
        while (i < arrayParameters.length) {
            DataAccessFactory.Param param = arrayParameters[i];
            if (!params.containsKey(param.key)) {
                if (param.required) {
                    return false;
                }
            } else {
                Object value;
                try {
                    value = param.lookUp(params);
                }
                catch (IOException e) {
                    return false;
                }
                if (value == null ? param.required : !param.type.isInstance(value)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean isAvailable() {
        return true;
    }

    public ParameterDescriptorGroup getParameters() {
        DataAccessFactory.Param[] params = this.getParametersInfo();
        DefaultParameterDescriptor[] parameters = new DefaultParameterDescriptor[params.length];
        int i = 0;
        while (i < params.length) {
            DataAccessFactory.Param param = params[i];
            parameters[i] = new ParamDescriptor(params[i]);
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", this.getDisplayName());
        properties.put("remarks", this.getDescription());
        return new DefaultParameterDescriptorGroup(properties, (GeneralParameterDescriptor[])parameters);
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

