/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLocking;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureLocking
extends AbstractFeatureStore
implements FeatureLocking<SimpleFeatureType, SimpleFeature>,
SimpleFeatureLocking {
    FeatureLock featureLock = FeatureLock.TRANSACTION;

    public AbstractFeatureLocking() {
    }

    public AbstractFeatureLocking(Set hints) {
        super(hints);
    }

    public void setFeatureLock(FeatureLock lock) {
        if (lock == null) {
            throw new NullPointerException("A FeatureLock is required - did you mean FeatureLock.TRANSACTION?");
        }
        this.featureLock = lock;
    }

    public int lockFeatures() throws IOException {
        return this.lockFeatures((Filter)Filter.INCLUDE);
    }

    public int lockFeatures(Filter filter) throws IOException {
        return this.lockFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    public int lockFeatures(Query query) throws IOException {
        int count;
        block9: {
            LockingManager lockingManager = this.getDataStore().getLockingManager();
            if (lockingManager == null) {
                throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
            }
            SimpleFeatureIterator reader = this.getFeatures(query).features();
            String typeName = query.getTypeName();
            count = 0;
            while (true) {
                if (reader.hasNext()) {
                    try {
                        SimpleFeature feature = (SimpleFeature)reader.next();
                        lockingManager.lockFeatureID(typeName, feature.getID(), this.getTransaction(), this.featureLock);
                        ++count;
                        continue;
                    }
                    catch (FeatureLockException featureLockException) {
                        continue;
                    }
                    catch (NoSuchElementException nosuch) {
                        throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)nosuch);
                    }
                }
                break block9;
                break;
            }
            finally {
                reader.close();
            }
        }
        return count;
    }

    public void unLockFeatures() throws IOException {
        this.unLockFeatures((Filter)Filter.INCLUDE);
    }

    public void unLockFeatures(Filter filter) throws IOException {
        this.unLockFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    public void unLockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        SimpleFeatureIterator reader = this.getFeatures(query).features();
        String typeName = query.getTypeName();
        try {
            while (reader.hasNext()) {
                try {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    lockingManager.unLockFeatureID(typeName, feature.getID(), this.getTransaction(), this.featureLock);
                }
                catch (NoSuchElementException nosuch) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)nosuch);
                }
            }
        }
        finally {
            reader.close();
        }
    }
}

