/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.SimpleFeatureCollectionBridge;
import org.geotools.data.SimpleFeatureLockingBridge;
import org.geotools.data.SimpleFeatureSourceBridge;
import org.geotools.data.SimpleFeatureStoreBridge;
import org.geotools.data.collection.CollectionDataStore;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.collection.SpatialIndexFeatureCollection;
import org.geotools.data.collection.SpatialIndexFeatureSource;
import org.geotools.data.collection.TreeSetFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.view.DefaultView;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.PropertyNameResolvingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUtilities {
    static Map<String, Class> typeMap = new HashMap<String, Class>();
    static Map<Class, String> typeEncode = new HashMap<Class, String>();
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    static {
        typeEncode.put(String.class, "String");
        typeMap.put("String", String.class);
        typeMap.put("string", String.class);
        typeMap.put("\"\"", String.class);
        typeEncode.put(Integer.class, "Integer");
        typeMap.put("Integer", Integer.class);
        typeMap.put("int", Integer.class);
        typeMap.put("0", Integer.class);
        typeEncode.put(Double.class, "Double");
        typeMap.put("Double", Double.class);
        typeMap.put("double", Double.class);
        typeMap.put("0.0", Double.class);
        typeEncode.put(Float.class, "Float");
        typeMap.put("Float", Float.class);
        typeMap.put("float", Float.class);
        typeMap.put("0.0f", Float.class);
        typeEncode.put(Boolean.class, "Boolean");
        typeMap.put("Boolean", Boolean.class);
        typeMap.put("true", Boolean.class);
        typeMap.put("false", Boolean.class);
        typeEncode.put(Geometry.class, "Geometry");
        typeMap.put("Geometry", Geometry.class);
        typeEncode.put(Point.class, "Point");
        typeMap.put("Point", Point.class);
        typeEncode.put(LineString.class, "LineString");
        typeMap.put("LineString", LineString.class);
        typeEncode.put(Polygon.class, "Polygon");
        typeMap.put("Polygon", Polygon.class);
        typeEncode.put(MultiPoint.class, "MultiPoint");
        typeMap.put("MultiPoint", MultiPoint.class);
        typeEncode.put(MultiLineString.class, "MultiLineString");
        typeMap.put("MultiLineString", MultiLineString.class);
        typeEncode.put(MultiPolygon.class, "MultiPolygon");
        typeMap.put("MultiPolygon", MultiPolygon.class);
        typeEncode.put(GeometryCollection.class, "GeometryCollection");
        typeMap.put("GeometryCollection", GeometryCollection.class);
        typeEncode.put(Date.class, "Date");
        typeMap.put("Date", Date.class);
    }

    public static String[] attributeNames(SimpleFeatureType featureType) {
        String[] names = new String[featureType.getAttributeCount()];
        int count = featureType.getAttributeCount();
        int i = 0;
        while (i < count) {
            names[i] = featureType.getDescriptor(i).getLocalName();
            ++i;
        }
        return names;
    }

    public static URL fileToURL(File file) {
        try {
            URL url = file.toURI().toURL();
            String string = url.toExternalForm();
            if (string.contains("+")) {
                string = string.replace("+", "%2B");
            }
            if (string.contains(" ")) {
                string = string.replace(" ", "%20");
            }
            return new URL(string);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static File urlToFile(URL url) {
        String path3;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        String string = url.toExternalForm();
        if (string.contains("+")) {
            string = string.replace("+", "%2B");
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not decode the URL to UTF-8 format", e);
        }
        String simplePrefix = "file:/";
        String standardPrefix = "file://";
        String os = System.getProperty("os.name");
        if (os.toUpperCase().contains("WINDOWS") && string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length() - 2);
        } else if (string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length());
        } else if (string.startsWith(simplePrefix)) {
            path3 = string.substring(simplePrefix.length() - 1);
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath().replace("%20", " ");
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File(path3);
    }

    public static String[] attributeNames(Filter filter, SimpleFeatureType featureType) {
        if (filter == null) {
            return new String[0];
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        filter.accept((FilterVisitor)attExtractor, null);
        String[] attributeNames = attExtractor.getAttributeNames();
        return attributeNames;
    }

    public static String[] attributeNames(Filter filter) {
        return DataUtilities.attributeNames(filter, null);
    }

    public static String[] attributeNames(Expression expression, SimpleFeatureType featureType) {
        if (expression == null) {
            return new String[0];
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        expression.accept((ExpressionVisitor)attExtractor, null);
        String[] attributeNames = attExtractor.getAttributeNames();
        return attributeNames;
    }

    public static String[] attributeNames(Expression expression) {
        return DataUtilities.attributeNames(expression, null);
    }

    public static int compare(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        int countB;
        if (typeA == typeB) {
            return 0;
        }
        if (typeA == null) {
            return -1;
        }
        if (typeB == null) {
            return -1;
        }
        int countA = typeA.getAttributeCount();
        if (countA > (countB = typeB.getAttributeCount())) {
            return -1;
        }
        int match = 0;
        int i = 0;
        while (i < countA) {
            AttributeDescriptor a = typeA.getDescriptor(i);
            if (DataUtilities.isMatch(a, typeB.getDescriptor(i))) {
                ++match;
            } else if (!DataUtilities.isMatch(a, typeB.getDescriptor(a.getLocalName()))) {
                return -1;
            }
            ++i;
        }
        if (countA == countB && match == countA) {
            return 0;
        }
        return 1;
    }

    public static boolean isMatch(AttributeDescriptor a, AttributeDescriptor b) {
        if (a == b) {
            return true;
        }
        if (b == null) {
            return false;
        }
        if (a == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        return a.getLocalName().equals(b.getLocalName()) && a.getClass().equals(b.getClass());
    }

    public static SimpleFeature reType(SimpleFeatureType featureType, SimpleFeature feature) throws IllegalAttributeException {
        SimpleFeatureType origional = feature.getFeatureType();
        if (featureType.equals((Object)origional)) {
            return SimpleFeatureBuilder.copy(feature);
        }
        String id = feature.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        int i = 0;
        while (i < numAtts) {
            AttributeDescriptor curAttType = featureType.getDescriptor(i);
            String xpath = curAttType.getLocalName();
            attributes[i] = DataUtilities.duplicate(feature.getAttribute(xpath));
            ++i;
        }
        return SimpleFeatureBuilder.build(featureType, attributes, id);
    }

    public static SimpleFeature reType(SimpleFeatureType featureType, SimpleFeature feature, boolean duplicate) throws IllegalAttributeException {
        if (duplicate) {
            return DataUtilities.reType(featureType, feature);
        }
        SimpleFeatureType origional = feature.getFeatureType();
        if (featureType.equals((Object)origional)) {
            return feature;
        }
        String id = feature.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        int i = 0;
        while (i < numAtts) {
            AttributeDescriptor curAttType = featureType.getDescriptor(i);
            attributes[i] = feature.getAttribute(curAttType.getLocalName());
            ++i;
        }
        return SimpleFeatureBuilder.build(featureType, attributes, id);
    }

    public static Object duplicate(Object src) {
        if (src == null) {
            return null;
        }
        if (src instanceof String || src instanceof Integer || src instanceof Double || src instanceof Float || src instanceof Byte || src instanceof Boolean || src instanceof Short || src instanceof Long || src instanceof Character || src instanceof Number) {
            return src;
        }
        if (src instanceof Date) {
            return new Date(((Date)src).getTime());
        }
        if (src instanceof URL || src instanceof URI) {
            return src;
        }
        if (src instanceof Object[]) {
            Object[] array = (Object[])src;
            Object[] copy = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                copy[i] = DataUtilities.duplicate(array[i]);
                ++i;
            }
            return copy;
        }
        if (src instanceof Geometry) {
            Geometry geometry = (Geometry)src;
            return geometry.clone();
        }
        if (src instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)src;
            return SimpleFeatureBuilder.copy(feature);
        }
        Class<?> type = src.getClass();
        if (type.isArray() && type.getComponentType().isPrimitive()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            System.arraycopy(src, 0, copy, 0, length);
            return copy;
        }
        if (type.isArray()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            int i = 0;
            while (i < length) {
                Array.set(copy, i, DataUtilities.duplicate(Array.get(src, i)));
                ++i;
            }
            return copy;
        }
        if (src instanceof List) {
            List list = (List)src;
            ArrayList<Object> copy = new ArrayList<Object>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                copy.add(DataUtilities.duplicate(i.next()));
            }
            return Collections.unmodifiableList(copy);
        }
        if (src instanceof Map) {
            Map map = (Map)src;
            HashMap copy = new HashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                copy.put(entry.getKey(), DataUtilities.duplicate(entry.getValue()));
            }
            return Collections.unmodifiableMap(copy);
        }
        if (src instanceof GridCoverage) {
            return src;
        }
        throw new IllegalAttributeException(null, (Object)("Do not know how to deep copy " + type.getName()));
    }

    public static SimpleFeature template(SimpleFeatureType featureType) throws IllegalAttributeException {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType), null);
    }

    public static SimpleFeature template(SimpleFeatureType featureType, String featureID) throws IllegalAttributeException {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType), featureID);
    }

    public static Object[] defaultValues(SimpleFeatureType featureType) throws IllegalAttributeException {
        return DataUtilities.defaultValues(featureType, null);
    }

    public static SimpleFeature template(SimpleFeatureType featureType, Object[] atts) throws IllegalAttributeException {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType, atts), null);
    }

    public static SimpleFeature template(SimpleFeatureType featureType, String featureID, Object[] atts) throws IllegalAttributeException {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType, atts), featureID);
    }

    public static Object[] defaultValues(SimpleFeatureType featureType, Object[] values) throws IllegalAttributeException {
        if (values == null) {
            values = new Object[featureType.getAttributeCount()];
        } else if (values.length != featureType.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException("values");
        }
        int i = 0;
        while (i < featureType.getAttributeCount()) {
            values[i] = DataUtilities.defaultValue(featureType.getDescriptor(i));
            ++i;
        }
        return values;
    }

    public static Object defaultValue(AttributeDescriptor attributeType) throws IllegalAttributeException {
        Object value = attributeType.getDefaultValue();
        if (value == null && !attributeType.isNillable()) {
            return null;
        }
        return value;
    }

    public static Object defaultValue(Class type) {
        if (type == String.class || type == Object.class) {
            return "";
        }
        if (type == Integer.class) {
            return new Integer(0);
        }
        if (type == Double.class) {
            return new Double(0.0);
        }
        if (type == Long.class) {
            return new Long(0L);
        }
        if (type == Short.class) {
            return new Short(0);
        }
        if (type == Float.class) {
            return new Float(0.0f);
        }
        if (type == BigDecimal.class) {
            return BigDecimal.valueOf(0L);
        }
        if (type == BigInteger.class) {
            return BigInteger.valueOf(0L);
        }
        if (type == Character.class) {
            return new Character(' ');
        }
        if (type == Boolean.class) {
            return Boolean.FALSE;
        }
        if (type == Timestamp.class) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(System.currentTimeMillis());
        }
        if (type == Time.class) {
            return new Time(System.currentTimeMillis());
        }
        if (type == Date.class) {
            return new Date();
        }
        GeometryFactory fac = new GeometryFactory();
        Coordinate coordinate = new Coordinate(0.0, 0.0);
        Point point = fac.createPoint(coordinate);
        if (type == Point.class) {
            return point;
        }
        if (type == MultiPoint.class) {
            return fac.createMultiPoint(new Point[]{point});
        }
        if (type == LineString.class) {
            return fac.createLineString(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        }
        LinearRing linearRing = fac.createLinearRing(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        if (type == LinearRing.class) {
            return linearRing;
        }
        if (type == MultiLineString.class) {
            return fac.createMultiLineString(new LineString[]{linearRing});
        }
        Polygon polygon = fac.createPolygon(linearRing, new LinearRing[0]);
        if (type == Polygon.class) {
            return polygon;
        }
        if (type == MultiPolygon.class) {
            return fac.createMultiPolygon(new Polygon[]{polygon});
        }
        throw new IllegalArgumentException(type + " is not supported by this method");
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> reader(final SimpleFeature[] features) throws IOException {
        if (features == null || features.length == 0) {
            throw new IOException("Provided features where empty");
        }
        return new FeatureReader<SimpleFeatureType, SimpleFeature>(){
            SimpleFeature[] array;
            int offset;
            {
                this.array = simpleFeatureArray;
                this.offset = -1;
            }

            public SimpleFeatureType getFeatureType() {
                return features[0].getFeatureType();
            }

            public SimpleFeature next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more features");
                }
                return this.array[++this.offset];
            }

            public boolean hasNext() {
                return this.array != null && this.offset < this.array.length - 1;
            }

            public void close() {
                this.array = null;
                this.offset = -1;
            }
        };
    }

    public static SimpleFeatureSource source(final SimpleFeature[] featureArray) {
        final SimpleFeatureType featureType = featureArray == null || featureArray.length == 0 ? FeatureTypes.EMPTY : featureArray[0].getFeatureType();
        AbstractDataStore arrayStore = new AbstractDataStore(){

            @Override
            public String[] getTypeNames() {
                return new String[]{featureType.getTypeName()};
            }

            @Override
            public SimpleFeatureType getSchema(String typeName) throws IOException {
                if (typeName != null && typeName.equals(featureType.getTypeName())) {
                    return featureType;
                }
                throw new IOException(String.valueOf(typeName) + " not available");
            }

            @Override
            protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
                return DataUtilities.reader(featureArray);
            }
        };
        try {
            return arrayStore.getFeatureSource(arrayStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Something is wrong with the geotools code, this exception should not happen", e);
        }
    }

    public static SimpleFeatureSource source(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection == null) {
            throw new NullPointerException("No content provided");
        }
        if (collection instanceof ListFeatureCollection) {
            ListFeatureCollection list = (ListFeatureCollection)collection;
            CollectionFeatureSource source = new CollectionFeatureSource(list);
            return source;
        }
        if (collection instanceof SpatialIndexFeatureCollection) {
            SpatialIndexFeatureCollection indexed = (SpatialIndexFeatureCollection)collection;
            SpatialIndexFeatureSource source = new SpatialIndexFeatureSource(indexed);
            return source;
        }
        if (collection instanceof TreeSetFeatureCollection) {
            TreeSetFeatureCollection tree = (TreeSetFeatureCollection)collection;
            CollectionFeatureSource source = new CollectionFeatureSource(tree);
            return source;
        }
        CollectionDataStore store = new CollectionDataStore(collection);
        try {
            return store.getFeatureSource(store.getTypeNames()[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Something is wrong with the geotools code, this exception should not happen", e);
        }
    }

    public static SimpleFeatureSource createView(DataStore store, Query query) throws IOException, SchemaException {
        return new DefaultView(store.getFeatureSource(query.getTypeName()), query);
    }

    public static SimpleFeatureCollection results(SimpleFeature[] featureArray) {
        return DataUtilities.results(DataUtilities.collection(featureArray));
    }

    public static SimpleFeatureCollection results(SimpleFeatureCollection collection) {
        collection.size();
        return collection;
    }

    public static <T extends FeatureType, F extends Feature> FeatureCollection<T, F> results(FeatureCollection<T, F> collection) {
        collection.size();
        return collection;
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> reader(Collection<SimpleFeature> collection) throws IOException {
        return DataUtilities.reader(collection.toArray(new SimpleFeature[collection.size()]));
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> reader(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        return DataUtilities.reader((SimpleFeature[])collection.toArray((Object[])new SimpleFeature[collection.size()]));
    }

    public static SimpleFeatureCollection collection(SimpleFeature[] features) {
        SimpleFeatureCollection collection = FeatureCollections.newCollection();
        int length = features.length;
        int i = 0;
        while (i < length) {
            collection.add((Feature)features[i]);
            ++i;
        }
        return collection;
    }

    public static DefaultFeatureCollection collection(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        return new DefaultFeatureCollection(featureCollection);
    }

    public static SimpleFeatureCollection simple(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        if (featureCollection instanceof SimpleFeatureCollection) {
            return (SimpleFeatureCollection)featureCollection;
        }
        if (featureCollection.getSchema() instanceof SimpleFeatureType) {
            return new SimpleFeatureCollectionBridge(featureCollection);
        }
        throw new IllegalArgumentException("The provided feature collection contains complex features, cannot be bridged to a simple one");
    }

    public static SimpleFeatureSource simple(FeatureSource source) {
        if (source instanceof FeatureLocking) {
            return DataUtilities.simple((FeatureLocking)source);
        }
        if (source instanceof FeatureStore) {
            return DataUtilities.simple((FeatureStore)source);
        }
        if (source instanceof SimpleFeatureSource) {
            return (SimpleFeatureSource)source;
        }
        if (source.getSchema() instanceof SimpleFeatureType) {
            return new SimpleFeatureSourceBridge((FeatureSource<SimpleFeatureType, SimpleFeature>)source);
        }
        throw new IllegalArgumentException("The provided feature source contains complex features, cannot be bridged to a simple one");
    }

    public static SimpleFeatureStore simple(FeatureStore store) {
        if (store instanceof FeatureLocking) {
            return DataUtilities.simple((FeatureLocking)store);
        }
        if (store instanceof SimpleFeatureStore) {
            return (SimpleFeatureStore)store;
        }
        if (store.getSchema() instanceof SimpleFeatureType) {
            return new SimpleFeatureStoreBridge((FeatureStore<SimpleFeatureType, SimpleFeature>)store);
        }
        throw new IllegalArgumentException("The provided feature store contains complex features, cannot be bridged to a simple one");
    }

    public static SimpleFeatureType simple(FeatureType featureType) throws DataSourceException {
        SimpleFeatureType simpleFeatureType;
        if (featureType == null) {
            return null;
        }
        Collection descriptors = featureType.getDescriptors();
        ArrayList attributes = new ArrayList(descriptors);
        ArrayList<String> simpleProperties = new ArrayList<String>();
        ArrayList<AttributeDescriptor> simpleAttributes = new ArrayList<AttributeDescriptor>();
        List<String> ignoreList = Arrays.asList("location", "metaDataProperty", "description", "name", "boundedBy");
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            AttributeDescriptor descriptor;
            Name name;
            PropertyDescriptor property = (PropertyDescriptor)it.next();
            if (!(property instanceof AttributeDescriptor) || !ignoreList.contains((name = (descriptor = (AttributeDescriptor)property).getName()).getLocalPart())) continue;
            it.remove();
        }
        for (PropertyDescriptor descriptor : attributes) {
            Class binding = descriptor.getType().getBinding();
            int maxOccurs = descriptor.getMaxOccurs();
            Name name = descriptor.getName();
            if (Object.class.equals((Object)binding) || maxOccurs > 1 || "http://www.opengis.net/gml".equals(name.getNamespaceURI()) || !(descriptor instanceof AttributeDescriptor)) continue;
            AttributeDescriptor attribute = (AttributeDescriptor)descriptor;
            simpleAttributes.add(attribute);
            simpleProperties.add(attribute.getLocalName());
        }
        String[] properties = simpleProperties.toArray(new String[simpleProperties.size()]);
        try {
            if (featureType instanceof SimpleFeature) {
                simpleFeatureType = DataUtilities.createSubType((SimpleFeatureType)featureType, properties);
            } else {
                SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
                build.setName(featureType.getName());
                build.setAttributes(simpleAttributes);
                build.setDefaultGeometry(featureType.getGeometryDescriptor().getLocalName());
                simpleFeatureType = build.buildFeatureType();
            }
        }
        catch (SchemaException e) {
            throw new DataSourceException((Throwable)e);
        }
        return simpleFeatureType;
    }

    public static SimpleFeatureLocking simple(FeatureLocking locking) {
        if (locking instanceof SimpleFeatureLocking) {
            return (SimpleFeatureLocking)locking;
        }
        if (locking.getSchema() instanceof SimpleFeatureType) {
            return new SimpleFeatureLockingBridge((FeatureLocking<SimpleFeatureType, SimpleFeature>)locking);
        }
        throw new IllegalArgumentException("The provided feature store contains complex features, cannot be bridged to a simple one");
    }

    public static List<SimpleFeature> list(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        final ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        try {
            featureCollection.accepts(new FeatureVisitor(){

                public void visit(Feature feature) {
                    list.add((SimpleFeature)feature);
                }
            }, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public static Set<String> fidSet(FeatureCollection<?, ?> featureCollection) {
        final HashSet<String> fids = new HashSet<String>();
        try {
            featureCollection.accepts(new FeatureVisitor(){

                public void visit(Feature feature) {
                    fids.add(feature.getIdentifier().getID());
                }
            }, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fids;
    }

    public static SimpleFeatureCollection collection(List<SimpleFeature> list) {
        SimpleFeatureCollection collection = FeatureCollections.newCollection();
        for (SimpleFeature feature : list) {
            collection.add((Feature)feature);
        }
        return collection;
    }

    public static SimpleFeatureCollection collection(SimpleFeature feature) {
        SimpleFeatureCollection collection = FeatureCollections.newCollection();
        collection.add((Feature)feature);
        return collection;
    }

    public static SimpleFeatureCollection collection(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        SimpleFeatureCollection collection = FeatureCollections.newCollection();
        try {
            while (reader.hasNext()) {
                try {
                    collection.add((Feature)((SimpleFeature)reader.next()));
                }
                catch (NoSuchElementException e) {
                    throw (IOException)new IOException("EOF").initCause(e);
                }
                catch (IllegalAttributeException e) {
                    throw (IOException)new IOException().initCause(e);
                }
            }
        }
        finally {
            reader.close();
        }
        return collection;
    }

    public static SimpleFeatureCollection collection(SimpleFeatureIterator reader) throws IOException {
        SimpleFeatureCollection collection = FeatureCollections.newCollection();
        try {
            while (reader.hasNext()) {
                try {
                    collection.add((Feature)((SimpleFeature)reader.next()));
                }
                catch (NoSuchElementException e) {
                    throw (IOException)new IOException("EOF").initCause(e);
                }
            }
        }
        finally {
            reader.close();
        }
        return collection;
    }

    public static boolean attributesEqual(Object att, Object otherAtt) {
        if (att == null) {
            if (otherAtt != null) {
                return false;
            }
        } else if (!att.equals(otherAtt)) {
            if (att instanceof Geometry && otherAtt instanceof Geometry) {
                if (!((Geometry)att).equals((Geometry)otherAtt)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType featureType, String[] properties, CoordinateReferenceSystem override) throws SchemaException {
        URI namespaceURI = null;
        if (featureType.getName().getNamespaceURI() != null) {
            try {
                namespaceURI = new URI(featureType.getName().getNamespaceURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return DataUtilities.createSubType(featureType, properties, override, featureType.getTypeName(), namespaceURI);
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType featureType, String[] properties, CoordinateReferenceSystem override, String typeName, URI namespace) throws SchemaException {
        if (properties == null && override == null) {
            return featureType;
        }
        if (properties == null) {
            properties = new String[featureType.getAttributeCount()];
            int i = 0;
            while (i < properties.length) {
                properties[i] = featureType.getDescriptor(i).getLocalName();
                ++i;
            }
        }
        String namespaceURI = namespace != null ? namespace.toString() : null;
        boolean same = featureType.getAttributeCount() == properties.length && featureType.getTypeName().equals(typeName) && Utilities.equals((Object)featureType.getName().getNamespaceURI(), (Object)namespaceURI);
        int i = 0;
        while (i < featureType.getAttributeCount() && same) {
            AttributeDescriptor type = featureType.getDescriptor(i);
            same = type.getLocalName().equals(properties[i]) && (override == null || !(type instanceof GeometryDescriptor) || DataUtilities.assertEquals(override, ((GeometryDescriptor)type).getCoordinateReferenceSystem()));
            ++i;
        }
        if (same) {
            return featureType;
        }
        AttributeDescriptor[] types = new AttributeDescriptor[properties.length];
        int i2 = 0;
        while (i2 < properties.length) {
            types[i2] = featureType.getDescriptor(properties[i2]);
            if (override != null && types[i2] instanceof GeometryDescriptor) {
                AttributeTypeBuilder ab = new AttributeTypeBuilder();
                ab.init(types[i2]);
                ab.setCRS(override);
                types[i2] = ab.buildDescriptor(types[i2].getLocalName(), ab.buildGeometryType());
            }
            ++i2;
        }
        if (typeName == null) {
            typeName = featureType.getTypeName();
        }
        if (namespace == null && featureType.getName().getNamespaceURI() != null) {
            try {
                namespace = new URI(featureType.getName().getNamespaceURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(typeName);
        tb.setNamespaceURI(namespace);
        tb.addAll(types);
        return tb.buildFeatureType();
    }

    private static boolean assertEquals(Object o1, Object o2) {
        return o1 == null && o2 == null ? true : (o1 != null ? o1.equals(o2) : false);
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType featureType, String[] properties) throws SchemaException {
        if (properties == null) {
            return featureType;
        }
        boolean same = featureType.getAttributeCount() == properties.length;
        int i = 0;
        while (i < featureType.getAttributeCount() && same) {
            same = featureType.getDescriptor(i).getLocalName().equals(properties[i]);
            ++i;
        }
        if (same) {
            return featureType;
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(featureType.getName());
        int i2 = 0;
        while (i2 < properties.length) {
            tb.add(featureType.getDescriptor(properties[i2]));
            ++i2;
        }
        return tb.buildFeatureType();
    }

    public static SimpleFeatureType createType(String identification, String typeSpec) throws SchemaException {
        int split = identification.lastIndexOf(46);
        String namespace = split == -1 ? null : identification.substring(0, split);
        String typeName = split == -1 ? identification : identification.substring(split + 1);
        return DataUtilities.createType(namespace, typeName, typeSpec);
    }

    public static SimpleFeatureType createType(String namespace, String typeName, String typeSpec) throws SchemaException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(typeName);
        tb.setNamespaceURI(namespace);
        String[] types = typeSpec.split(",");
        int i = 0;
        while (i < types.length) {
            boolean defaultGeometry = types[i].startsWith("*");
            if (types[i].startsWith("*")) {
                types[i] = types[i].substring(1);
            }
            AttributeDescriptor attributeType = DataUtilities.createAttribute(types[i]);
            tb.add(attributeType);
            if (defaultGeometry) {
                tb.setDefaultGeometry(attributeType.getLocalName());
            }
            ++i;
        }
        return tb.buildFeatureType();
    }

    public static SimpleFeature parse(SimpleFeatureType type, String fid, String[] text) throws IllegalAttributeException {
        Object[] attributes = new Object[text.length];
        int i = 0;
        while (i < text.length) {
            AttributeType attType = type.getDescriptor(i).getType();
            attributes[i] = Converters.convert((Object)text[i], (Class)attType.getBinding());
            ++i;
        }
        return SimpleFeatureBuilder.build(type, attributes, fid);
    }

    public static String spec(FeatureType featureType) {
        Collection types = featureType.getDescriptors();
        StringBuffer buf = new StringBuffer();
        for (PropertyDescriptor type : types) {
            GeometryDescriptor gd;
            buf.append(type.getName().getLocalPart());
            buf.append(":");
            buf.append(DataUtilities.typeMap(type.getType().getBinding()));
            if (type instanceof GeometryDescriptor && (gd = (GeometryDescriptor)type).getCoordinateReferenceSystem() != null && gd.getCoordinateReferenceSystem().getIdentifiers() != null) {
                for (ReferenceIdentifier id : gd.getCoordinateReferenceSystem().getIdentifiers()) {
                    if (id.getAuthority() == null || !id.getAuthority().getTitle().equals(Citations.EPSG.getTitle())) continue;
                    buf.append(":srid=" + id.getCode());
                    break;
                }
            }
            buf.append(",");
        }
        buf.delete(buf.length() - 1, buf.length());
        return buf.toString();
    }

    static Class type(String typeName) throws ClassNotFoundException {
        if (typeMap.containsKey(typeName)) {
            return typeMap.get(typeName);
        }
        return Class.forName(typeName);
    }

    static String typeMap(Class type) {
        if (typeEncode.containsKey(type)) {
            return typeEncode.get(type);
        }
        return type.getName();
    }

    public static Comparator<SimpleFeature> sortComparator(SortBy sortBy) {
        if (sortBy == null) {
            sortBy = SortBy.NATURAL_ORDER;
        }
        if (sortBy == SortBy.NATURAL_ORDER) {
            return new Comparator<SimpleFeature>(){

                @Override
                public int compare(SimpleFeature f1, SimpleFeature f2) {
                    return f1.getID().compareTo(f2.getID());
                }
            };
        }
        if (sortBy == SortBy.REVERSE_ORDER) {
            return new Comparator<SimpleFeature>(){

                @Override
                public int compare(SimpleFeature f1, SimpleFeature f2) {
                    int compare = f1.getID().compareTo(f2.getID());
                    return -compare;
                }
            };
        }
        final PropertyName PROPERTY = sortBy.getPropertyName();
        return new Comparator<SimpleFeature>(){

            @Override
            public int compare(SimpleFeature f1, SimpleFeature f2) {
                Object value1 = PROPERTY.evaluate((Object)f1, Comparable.class);
                Object value2 = PROPERTY.evaluate((Object)f2, Comparable.class);
                if (value1 == null || value2 == null) {
                    return 0;
                }
                if (value1 instanceof Comparable && value1.getClass().isInstance(value2)) {
                    return ((Comparable)value1).compareTo(value2);
                }
                return 0;
            }
        };
    }

    public static Query mixQueries(Query firstQuery, Query secondQuery, String handle) {
        String version;
        if (firstQuery == null && secondQuery == null) {
            return Query.ALL;
        }
        if (firstQuery == null || firstQuery.equals((Object)Query.ALL)) {
            return secondQuery;
        }
        if (secondQuery == null || secondQuery.equals((Object)Query.ALL)) {
            return firstQuery;
        }
        if (firstQuery.getTypeName() != null && secondQuery.getTypeName() != null && !firstQuery.getTypeName().equals(secondQuery.getTypeName())) {
            String msg = "Type names do not match: " + firstQuery.getTypeName() + " != " + secondQuery.getTypeName();
            throw new IllegalArgumentException(msg);
        }
        if (firstQuery.getVersion() != null) {
            if (secondQuery.getVersion() != null && !secondQuery.getVersion().equals(firstQuery.getVersion())) {
                throw new IllegalArgumentException("First and second query refer different versions");
            }
            version = firstQuery.getVersion();
        } else {
            version = secondQuery.getVersion();
        }
        int maxFeatures = Math.min(firstQuery.getMaxFeatures(), secondQuery.getMaxFeatures());
        String[] propNames = DataUtilities.joinAttributes(firstQuery.getPropertyNames(), secondQuery.getPropertyNames());
        Filter filter = firstQuery.getFilter();
        Filter filter2 = secondQuery.getFilter();
        if (filter == null || filter.equals(Filter.INCLUDE)) {
            filter = filter2;
        } else if (filter2 != null && !filter2.equals(Filter.INCLUDE)) {
            filter = ff.and(filter, filter2);
        }
        Integer start = 0;
        if (firstQuery.getStartIndex() != null) {
            start = firstQuery.getStartIndex();
        }
        if (secondQuery.getStartIndex() != null) {
            start = start + secondQuery.getStartIndex();
        }
        Hints hints = new Hints();
        if (firstQuery.getHints() != null) {
            hints.putAll((Map)firstQuery.getHints());
        }
        if (secondQuery.getHints() != null) {
            hints.putAll((Map)secondQuery.getHints());
        }
        String typeName = firstQuery.getTypeName() != null ? firstQuery.getTypeName() : secondQuery.getTypeName();
        Query mixed = new Query(typeName, filter, maxFeatures, propNames, handle);
        mixed.setVersion(version);
        mixed.setHints(hints);
        if (start != 0) {
            mixed.setStartIndex(start);
        }
        return mixed;
    }

    public static Query resolvePropertyNames(Query query, SimpleFeatureType schema) {
        Filter resolved = DataUtilities.resolvePropertyNames(query.getFilter(), schema);
        if (resolved == query.getFilter()) {
            return query;
        }
        Query newQuery = new Query(query);
        newQuery.setFilter(resolved);
        return newQuery;
    }

    public static Filter resolvePropertyNames(Filter filter, SimpleFeatureType schema) {
        if (filter == null || filter == Filter.INCLUDE || filter == Filter.EXCLUDE) {
            return filter;
        }
        return (Filter)filter.accept((FilterVisitor)new PropertyNameResolvingVisitor(schema), null);
    }

    private static String[] joinAttributes(String[] atts1, String[] atts2) {
        String[] propNames = null;
        if (atts1 == null && atts2 == null) {
            return null;
        }
        LinkedList<String> atts = new LinkedList<String>();
        if (atts1 != null) {
            atts.addAll(Arrays.asList(atts1));
        }
        if (atts2 != null) {
            int i = 0;
            while (i < atts2.length) {
                if (!atts.contains(atts2[i])) {
                    atts.add(atts2[i]);
                }
                ++i;
            }
        }
        propNames = new String[atts.size()];
        atts.toArray(propNames);
        return propNames;
    }

    static AttributeDescriptor createAttribute(String typeSpec) throws SchemaException {
        String type;
        String name;
        int split = typeSpec.indexOf(":");
        String hint = null;
        if (split == -1) {
            name = typeSpec;
            type = "String";
        } else {
            name = typeSpec.substring(0, split);
            int split2 = typeSpec.indexOf(":", split + 1);
            if (split2 == -1) {
                type = typeSpec.substring(split + 1);
            } else {
                type = typeSpec.substring(split + 1, split2);
                hint = typeSpec.substring(split2 + 1);
            }
        }
        try {
            AttributeTypeImpl at;
            Class clazz;
            boolean nillable = true;
            CoordinateReferenceSystem crs = null;
            if (hint != null) {
                StringTokenizer st = new StringTokenizer(hint, ";");
                while (st.hasMoreTokens()) {
                    String h = st.nextToken();
                    if ((h = h.trim()).equals("nillable")) {
                        nillable = true;
                    }
                    if (!h.startsWith("srid=")) continue;
                    String srid = h.split("=")[1];
                    Integer.parseInt(srid);
                    try {
                        crs = CRS.decode((String)("EPSG:" + srid));
                    }
                    catch (Exception e) {
                        String msg = "Error decoding srs: " + srid;
                        throw new SchemaException(msg, (Throwable)e);
                    }
                }
            }
            if (Geometry.class.isAssignableFrom(clazz = DataUtilities.type(type))) {
                at = new GeometryTypeImpl((Name)new NameImpl(name), clazz, crs, false, false, Collections.EMPTY_LIST, null, null);
                return new GeometryDescriptorImpl((GeometryType)at, (Name)new NameImpl(name), 0, 1, nillable, null);
            }
            at = new AttributeTypeImpl((Name)new NameImpl(name), clazz, false, false, Collections.EMPTY_LIST, null, null);
            return new AttributeDescriptorImpl(at, (Name)new NameImpl(name), 0, 1, nillable, null);
        }
        catch (ClassNotFoundException e) {
            throw new SchemaException("Could not type " + name + " as:" + type, (Throwable)e);
        }
    }

    public static Envelope bounds(FeatureCollection<? extends FeatureType, ? extends Feature> collection) {
        FeatureIterator i = collection.features();
        try {
            ReferencedEnvelope bounds = new ReferencedEnvelope(collection.getSchema().getCoordinateReferenceSystem());
            if (!i.hasNext()) {
                bounds.setToNull();
                ReferencedEnvelope referencedEnvelope = bounds;
                return referencedEnvelope;
            }
            bounds.init(((SimpleFeature)i.next()).getBounds());
            ReferencedEnvelope referencedEnvelope = bounds;
            return referencedEnvelope;
        }
        finally {
            i.close();
        }
    }

    public static URL changeUrlExt(URL url, String postfix) throws IllegalArgumentException {
        String a = url.toExternalForm();
        int lastDotPos = a.lastIndexOf(46);
        if (lastDotPos >= 0) {
            a = a.substring(0, lastDotPos);
        }
        a = String.valueOf(a) + "." + postfix;
        try {
            return new URL(a);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("can't create a new URL for " + url + " with new extension " + postfix, e);
        }
    }

    public static URL getParentUrl(URL url) throws MalformedURLException {
        String a = url.toExternalForm();
        int lastDotPos = a.lastIndexOf(47);
        if (lastDotPos >= 0) {
            a = a.substring(0, lastDotPos);
        }
        if (a.endsWith("!")) {
            a = String.valueOf(a) + "/";
        }
        return new URL(a);
    }

    public static URL extendURL(URL base, String extension) throws MalformedURLException {
        if (base == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"base"));
        }
        if (extension == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"extension"));
        }
        String a = base.toExternalForm();
        if (!a.endsWith("/")) {
            a = String.valueOf(a) + "/";
        }
        a = String.valueOf(a) + extension;
        return new URL(a);
    }

    public static boolean checkFileReadable(File file, Logger logger) {
        if (logger != null && logger.isLoggable(Level.FINE)) {
            StringBuilder builder = new StringBuilder("Checking file:").append(file.getAbsolutePath()).append("\n").append("canRead:").append(file.canRead()).append("\n").append("isHidden:").append(file.isHidden()).append("\n").append("isFile").append(file.isFile()).append("\n").append("canWrite").append(file.canWrite()).append("\n");
            logger.fine(builder.toString());
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    public static File checkDirectory(File file) throws IllegalArgumentException {
        String directoryPath = file.getPath();
        File inDir = file;
        if (!inDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directoryPath);
        }
        if (!inDir.canRead()) {
            throw new IllegalArgumentException("Not a writable directory: " + directoryPath);
        }
        try {
            directoryPath = inDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        inDir = new File(directoryPath);
        if (!inDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directoryPath);
        }
        if (!inDir.canRead()) {
            throw new IllegalArgumentException("Not a writable directory: " + directoryPath);
        }
        return new File(directoryPath);
    }

    public static FilenameFilter excludeFilters(final FilenameFilter inputFilter, final FilenameFilter ... filters) {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (inputFilter.accept(dir, name)) {
                    FilenameFilter[] filenameFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FilenameFilter exclude = filenameFilterArray[n2];
                        if (exclude.accept(dir, name)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static FilenameFilter includeFilters(final FilenameFilter inputFilter, final FilenameFilter ... filters) {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (inputFilter.accept(dir, name)) {
                    return true;
                }
                FilenameFilter[] filenameFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    FilenameFilter include = filenameFilterArray[n2];
                    if (include.accept(dir, name)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }
}

