/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import org.geotools.data.DefaultFeatureLock;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;

public class DefaultFeatureLockFactory
extends FeatureLockFactory {
    static long count = 0L;

    protected FeatureLock createLock(String name, long duration) {
        long number = DefaultFeatureLockFactory.nextIdNumber(duration);
        return new DefaultFeatureLock(String.valueOf(name) + "_" + Long.toString(number, 16), duration);
    }

    static FeatureLock createTestLock(String name, long duration) {
        return new DefaultFeatureLock(name, duration);
    }

    static void seedIdNumber(long seed) {
        count = seed;
    }

    static long nextIdNumber(long duration) {
        long now = System.currentTimeMillis();
        long time = now + duration;
        long number = ++count;
        number ^= time;
        StringBuffer reverse = new StringBuffer(DefaultFeatureLockFactory.asBits(now));
        now = Long.parseLong(reverse.reverse().toString(), 2);
        return number ^= now;
    }

    private static String asBits(long number) {
        long yum = number;
        StringBuffer buf = new StringBuffer(32);
        int i = 0;
        while (i < 63) {
            buf.append(yum & 1L);
            yum >>= 1;
            ++i;
        }
        buf.reverse();
        return buf.toString();
    }
}

