/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.AttributeReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private final AttributeReader attributeReader;
    private final SimpleFeatureType schema;
    protected final Object[] attributes;

    public DefaultFeatureReader(AttributeReader attributeReader, SimpleFeatureType schema) throws SchemaException {
        this.attributeReader = attributeReader;
        if (schema == null) {
            schema = this.createSchema();
        }
        this.schema = schema;
        this.attributes = new Object[attributeReader.getAttributeCount()];
    }

    public DefaultFeatureReader(AttributeReader attributeReader) throws SchemaException {
        this(attributeReader, null);
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        SimpleFeature f = null;
        if (this.attributeReader.hasNext()) {
            this.attributeReader.next();
            f = this.readFeature(this.attributeReader);
        }
        return f;
    }

    protected SimpleFeatureType createSchema() throws SchemaException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        int i = 0;
        int ii = this.attributeReader.getAttributeCount();
        while (i < ii) {
            builder.add(this.attributeReader.getAttributeType(i));
            ++i;
        }
        return builder.buildFeatureType();
    }

    protected SimpleFeature readFeature(AttributeReader atts) throws IllegalAttributeException, IOException {
        int i = 0;
        int ii = atts.getAttributeCount();
        while (i < ii) {
            this.attributes[i] = atts.read(i);
            ++i;
        }
        return SimpleFeatureBuilder.build(this.schema, this.attributes, null);
    }

    public void close() throws IOException {
        this.attributeReader.close();
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public boolean hasNext() throws IOException {
        return this.attributeReader.hasNext();
    }
}

