/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.AttributeReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIDFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data");
    private final AttributeReader attributeReader;
    private final SimpleFeatureType schema;
    private final FIDReader fidReader;
    protected final Object[] attributes;
    private SimpleFeatureBuilder builder;
    private Boolean hasNextFlag;

    public FIDFeatureReader(AttributeReader attributeReader, FIDReader fidReader, SimpleFeatureType schema) throws SchemaException {
        this.attributeReader = attributeReader;
        this.fidReader = fidReader;
        if (schema == null) {
            schema = this.createSchema();
        }
        this.schema = schema;
        this.attributes = new Object[attributeReader.getAttributeCount()];
        this.builder = new SimpleFeatureBuilder(schema);
    }

    public FIDFeatureReader(AttributeReader attributeReader, FIDReader fidReader) throws SchemaException {
        this(attributeReader, fidReader, null);
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            this.hasNextFlag = null;
            this.attributeReader.next();
            return this.readFeature(this.attributeReader);
        }
        throw new NoSuchElementException("There are no more Features to be read");
    }

    protected SimpleFeatureType createSchema() throws SchemaException {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("xxx");
        int i = 0;
        int ii = this.attributeReader.getAttributeCount();
        while (i < ii) {
            b.add(this.attributeReader.getAttributeType(i));
            ++i;
        }
        return b.buildFeatureType();
    }

    protected SimpleFeature readFeature(AttributeReader atts) throws IllegalAttributeException, IOException {
        String fid = this.fidReader.next();
        int i = 0;
        int ii = atts.getAttributeCount();
        while (i < ii) {
            this.builder.add(atts.read(i));
            ++i;
        }
        return this.builder.buildFeature(fid);
    }

    public void close() throws IOException {
        this.fidReader.close();
        this.attributeReader.close();
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public boolean hasNext() throws IOException {
        if (this.hasNextFlag == null) {
            this.hasNextFlag = this.attributeReader.hasNext();
        }
        return this.hasNextFlag;
    }
}

