/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import org.geotools.data.AttributeReader;
import org.opengis.feature.type.AttributeDescriptor;

public class JoiningAttributeReader
implements AttributeReader {
    private AttributeReader[] readers;
    private int[] index;
    private AttributeDescriptor[] metaData;

    public JoiningAttributeReader(AttributeReader[] readers) {
        this.readers = readers;
        this.metaData = this.joinMetaData(readers);
    }

    private AttributeDescriptor[] joinMetaData(AttributeReader[] readers) {
        int total = 0;
        this.index = new int[readers.length];
        int i = 0;
        int ii = readers.length;
        while (i < ii) {
            this.index[i] = total;
            total += readers[i].getAttributeCount();
            ++i;
        }
        AttributeDescriptor[] md = new AttributeDescriptor[total];
        int idx = 0;
        int i2 = 0;
        int ii2 = readers.length;
        while (i2 < ii2) {
            int j = 0;
            int jj = readers[i2].getAttributeCount();
            while (j < jj) {
                md[idx] = readers[i2].getAttributeType(j);
                ++idx;
                ++j;
            }
            ++i2;
        }
        return md;
    }

    public void close() throws IOException {
        IOException dse = null;
        int i = 0;
        int ii = this.readers.length;
        while (i < ii) {
            try {
                this.readers[i].close();
            }
            catch (IOException e) {
                dse = e;
            }
            ++i;
        }
        if (dse != null) {
            throw dse;
        }
    }

    public boolean hasNext() throws IOException {
        int i = 0;
        int ii = this.readers.length;
        while (i < ii) {
            if (this.readers[i].hasNext()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void next() throws IOException {
        int i = 0;
        int ii = this.readers.length;
        while (i < ii) {
            if (this.readers[i].hasNext()) {
                this.readers[i].next();
            }
            ++i;
        }
    }

    public Object read(int idx) throws IOException {
        AttributeReader reader = null;
        int i = this.index.length - 1;
        while (i >= 0) {
            if (idx >= this.index[i]) {
                idx -= this.index[i];
                reader = this.readers[i];
                break;
            }
            --i;
        }
        if (reader == null) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return reader.read(idx);
    }

    public int getAttributeCount() {
        return this.metaData.length;
    }

    public AttributeDescriptor getAttributeType(int i) {
        return this.metaData[i];
    }
}

