/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import org.geotools.data.AttributeWriter;
import org.opengis.feature.type.AttributeDescriptor;

public class JoiningAttributeWriter
implements AttributeWriter {
    private AttributeWriter[] writers;
    private int[] index;
    private AttributeDescriptor[] metaData;

    public JoiningAttributeWriter(AttributeWriter[] writers) {
        this.writers = writers;
        this.metaData = this.joinMetaData(writers);
    }

    private AttributeDescriptor[] joinMetaData(AttributeWriter[] writers) {
        int total = 0;
        this.index = new int[writers.length];
        int i = 0;
        int ii = writers.length;
        while (i < ii) {
            this.index[i] = total;
            total += writers[i].getAttributeCount();
            ++i;
        }
        AttributeDescriptor[] md = new AttributeDescriptor[total];
        int idx = 0;
        int i2 = 0;
        int ii2 = writers.length;
        while (i2 < ii2) {
            int j = 0;
            int jj = writers[i2].getAttributeCount();
            while (j < jj) {
                md[idx] = writers[i2].getAttributeType(j);
                ++idx;
                ++j;
            }
            ++i2;
        }
        return md;
    }

    public void close() throws IOException {
        IOException dse = null;
        int i = 0;
        int ii = this.writers.length;
        while (i < ii) {
            try {
                this.writers[i].close();
            }
            catch (IOException e) {
                dse = e;
            }
            ++i;
        }
        if (dse != null) {
            throw dse;
        }
    }

    public boolean hasNext() throws IOException {
        int i = 0;
        int ii = this.writers.length;
        while (i < ii) {
            if (this.writers[i].hasNext()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void next() throws IOException {
        int i = 0;
        int ii = this.writers.length;
        while (i < ii) {
            this.writers[i].next();
            ++i;
        }
    }

    public void write(int position, Object attribute) throws IOException {
        AttributeWriter writer = null;
        int i = this.index.length - 1;
        while (i >= 0) {
            if (position >= this.index[i]) {
                position -= this.index[i];
                writer = this.writers[i];
                break;
            }
            --i;
        }
        if (writer == null) {
            throw new ArrayIndexOutOfBoundsException(position);
        }
        writer.write(position, attribute);
    }

    public int getAttributeCount() {
        return this.metaData.length;
    }

    public AttributeDescriptor getAttributeType(int i) {
        return this.metaData[i];
    }
}

