/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpatialIndexFeatureCollection
implements SimpleFeatureCollection {
    static Logger LOGGER = Logging.getLogger(SpatialIndexFeatureCollection.class);
    protected STRtree index = new STRtree();
    protected SimpleFeatureType schema;
    protected List<CollectionListener> listeners = null;

    public synchronized void addListener(CollectionListener listener) throws NullPointerException {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(CollectionListener listener) throws NullPointerException {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void fire(SimpleFeature[] features, int eventType) {
        CollectionListener[] notify;
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        CollectionEvent event = new CollectionEvent((FeatureCollection)this, features, eventType);
        CollectionListener[] collectionListenerArray = notify = this.listeners.toArray(new CollectionListener[this.listeners.size()]);
        int n = notify.length;
        int n2 = 0;
        while (n2 < n) {
            CollectionListener listener = collectionListenerArray[n2];
            try {
                listener.collectionChanged(event);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Problem encountered during notification of " + event, t);
            }
            ++n2;
        }
    }

    public SimpleFeatureIterator features() {
        Envelope everything = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        List list = this.index.query(everything);
        final Iterator iterator = list.iterator();
        return new SimpleFeatureIterator(){

            public SimpleFeature next() throws NoSuchElementException {
                return (SimpleFeature)iterator.next();
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public void close() {
            }
        };
    }

    public SimpleFeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener listener) throws IOException {
        Envelope everything = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        Object progress = listener != null ? listener : new NullProgressListener();
        progress.started();
        float size = this.size();
        this.index.query(everything, new ItemVisitor((ProgressListener)progress, size, visitor){
            float count = 0.0f;
            private final /* synthetic */ ProgressListener val$progress;
            private final /* synthetic */ float val$size;
            private final /* synthetic */ FeatureVisitor val$visitor;
            {
                this.val$progress = progressListener;
                this.val$size = f;
                this.val$visitor = featureVisitor;
            }

            public void visitItem(Object item) {
                try {
                    try {
                        SimpleFeature feature = (SimpleFeature)item;
                        this.val$visitor.visit((Feature)feature);
                    }
                    catch (Throwable t) {
                        this.val$progress.exceptionOccurred(t);
                        this.val$progress.progress(this.count / this.val$size);
                    }
                }
                finally {
                    this.val$progress.progress(this.count / this.val$size);
                }
            }
        });
        progress.complete();
    }

    public boolean add(SimpleFeature feature) {
        ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)feature.getBounds());
        this.index.insert((Envelope)bounds, (Object)feature);
        return false;
    }

    public boolean addAll(Collection<? extends SimpleFeature> collection) {
        for (SimpleFeature simpleFeature : collection) {
            try {
                ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)simpleFeature.getBounds());
                this.index.insert((Envelope)bounds, (Object)simpleFeature);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public boolean addAll(FeatureCollection<? extends SimpleFeatureType, ? extends SimpleFeature> collection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void clear() {
        this.index = null;
        this.index = new STRtree();
        this.listeners.clear();
        this.listeners = null;
    }

    public void close(FeatureIterator<SimpleFeature> close) {
    }

    public void close(Iterator<SimpleFeature> close) {
    }

    public boolean contains(Object obj) {
        if (obj instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)obj;
            ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)feature.getBounds());
            Iterator iter = (Iterator)((Object)this.index.query((Envelope)bounds));
            while (iter.hasNext()) {
                SimpleFeature sample = (SimpleFeature)iter.next();
                if (sample != feature) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAll(Collection<?> collection) {
        boolean containsAll = true;
        for (Object obj : collection) {
            boolean contains = this.contains(obj);
            if (contains) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public ReferencedEnvelope getBounds() {
        CoordinateReferenceSystem crs = this.schema.getCoordinateReferenceSystem();
        Envelope bounds = (Envelope)this.index.getRoot().getBounds();
        return new ReferencedEnvelope(bounds, crs);
    }

    public String getID() {
        return null;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public boolean isEmpty() {
        return this.index.itemsTree().isEmpty();
    }

    public Iterator<SimpleFeature> iterator() {
        Envelope everything = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        List list = this.index.query(everything);
        return list.iterator();
    }

    public void purge() {
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove items from STRtree");
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove items from STRtree");
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove items from STRtree");
    }

    public int size() {
        return this.index.size();
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public <O> O[] toArray(O[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            O[] result = array;
            int i = 0;
            while (i < size) {
                result[i] = it.next();
                ++i;
            }
            if (array.length > size) {
                array[size] = null;
            }
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.close(it);
        }
    }
}

