/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.collection.SpatialIndexFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class SpatialIndexFeatureSource
implements SimpleFeatureSource {
    SpatialIndexFeatureCollection contents;
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private static final Set<Class> supportedFilterTypes = new HashSet<Class>(Arrays.asList(BBOX.class, Contains.class, Crosses.class, DWithin.class, Equals.class, Intersects.class, Overlaps.class, Touches.class, Within.class));

    public SpatialIndexFeatureSource(SpatialIndexFeatureCollection original) {
        this.contents = original;
    }

    public void addFeatureListener(FeatureListener listener) {
    }

    public void removeFeatureListener(FeatureListener listener) {
    }

    public DataStore getDataStore() {
        return null;
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.contents.getBounds();
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.getFeatures(query).getBounds();
    }

    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    public SimpleFeatureType getSchema() {
        return this.contents.getSchema();
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.contents;
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        Query query = new Query(this.getSchema().getName().getLocalPart(), filter);
        return this.getFeatures(query);
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        Envelope bounds = this.getEnvelope(query.getFilter());
        return this.getFeatureCollection(query, bounds);
    }

    private SimpleFeatureCollection getFeatureCollection(Query query, Envelope bounds) throws IOException {
        SimpleFeatureType schema;
        SimpleFeatureType target;
        Object copy;
        int offset = (query = DataUtilities.resolvePropertyNames(query, this.getSchema())).getStartIndex() != null ? query.getStartIndex() : 0;
        if (offset > 0 & query.getSortBy() == null) {
            if (!this.getQueryCapabilities().supportsSorting(query.getSortBy())) {
                throw new IllegalStateException("Feature source does not support this sorting so there is no way a stable paging (offset/limit) can be performed");
            }
            copy = new Query(query);
            copy.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
            query = copy;
        }
        if (query.getFilter() != null && query.getFilter().equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        if (query.getFilter() != null && query.getFilter().equals(Filter.INCLUDE)) {
            copy = this.contents;
        }
        SimpleFeatureCollection collection = query.getFilter() != null && query.getFilter().equals(Filter.INCLUDE) ? this.contents : this.contents.subCollection(query.getFilter());
        if (query.getCoordinateSystemReproject() != null) {
            collection = new ReprojectingFeatureCollection(collection, query.getCoordinateSystemReproject());
        }
        if (query.getSortBy() != null && query.getSortBy().length != 0) {
            SimpleFeature[] array = (SimpleFeature[])collection.toArray((Object[])new SimpleFeature[collection.size()]);
            SortBy[] sortByArray = query.getSortBy();
            int n = sortByArray.length;
            int n2 = 0;
            while (n2 < n) {
                SortBy sortBy = sortByArray[n2];
                Comparator<SimpleFeature> comparator = DataUtilities.sortComparator(sortBy);
                Arrays.sort(array, comparator);
                ++n2;
            }
            ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>(Arrays.asList(array));
            collection = new ListFeatureCollection(this.getSchema(), list);
        }
        if (offset > 0 || !query.isMaxFeaturesUnlimited()) {
            long max = Long.MAX_VALUE;
            if (!query.isMaxFeaturesUnlimited()) {
                max = query.getMaxFeatures();
            }
            collection = new MaxSimpleFeatureCollection(collection, offset, max);
        }
        if (query.getPropertyNames() != Query.ALL_NAMES && !(target = SimpleFeatureTypeBuilder.retype(schema = (SimpleFeatureType)collection.getSchema(), query.getPropertyNames())).equals((Object)schema)) {
            collection = new ReTypingFeatureCollection(collection, target);
        }
        return collection;
    }

    Envelope getEnvelope(Filter filter) {
        BinarySpatialOperator gf;
        Envelope result = new Envelope();
        if (filter instanceof And) {
            Envelope bounds = new Envelope();
            for (Filter f : ((And)filter).getChildren()) {
                Envelope e = this.getEnvelope(f);
                if (e == null) {
                    return null;
                }
                bounds.expandToInclude(e);
            }
            result = bounds;
        } else if (filter instanceof BinarySpatialOperator && supportedFilterTypes.contains((gf = (BinarySpatialOperator)filter).getClass())) {
            Expression lg = gf.getExpression1();
            Expression rg = gf.getExpression2();
            if (lg instanceof Literal) {
                Geometry g = (Geometry)((Literal)lg).getValue();
                if (rg instanceof PropertyName) {
                    result = g.getEnvelopeInternal();
                }
            } else if (rg instanceof Literal) {
                Geometry g = (Geometry)((Literal)rg).getValue();
                if (lg instanceof PropertyName) {
                    result = g.getEnvelopeInternal();
                }
            }
        }
        return result;
    }

    private BBOX bboxFilter(Envelope bbox) {
        return ff.bbox(this.contents.getSchema().getGeometryDescriptor().getLocalName(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), null);
    }

    public ResourceInfo getInfo() {
        return null;
    }

    public Name getName() {
        return this.contents.getSchema().getName();
    }

    public QueryCapabilities getQueryCapabilities() {
        return new QueryCapabilities(){

            public boolean isOffsetSupported() {
                return true;
            }
        };
    }

    public Set getSupportedHints() {
        HashSet hints = new HashSet();
        return hints;
    }
}

