/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.geotools.ows.ServiceException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ServiceExceptionParser {
    public static ServiceException parse(InputStream inputStream) throws JDOMException, IOException {
        ServiceException exception;
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(inputStream);
        Element root = document.getRootElement();
        List serviceExceptions = root.getChildren("ServiceException");
        ArrayList<ServiceException> codes = new ArrayList<ServiceException>();
        ArrayList<ServiceException> noCodes = new ArrayList<ServiceException>();
        int i = 0;
        while (i < serviceExceptions.size()) {
            Element element = (Element)serviceExceptions.get(i);
            ServiceException exception2 = ServiceExceptionParser.parseSE(element);
            if (exception2.getCode() != null && exception2.getCode().length() != 0) {
                codes.add(exception2);
            } else {
                noCodes.add(exception2);
            }
            ++i;
        }
        ServiceException firstException = null;
        ServiceException recentException = null;
        int i2 = 0;
        while (i2 < codes.size()) {
            exception = (ServiceException)codes.get(i2);
            if (firstException == null) {
                firstException = exception;
                recentException = exception;
            } else {
                recentException.setNext(exception);
                recentException = exception;
            }
            ++i2;
        }
        codes = null;
        i2 = 0;
        while (i2 < noCodes.size()) {
            exception = (ServiceException)noCodes.get(i2);
            if (firstException == null) {
                firstException = exception;
                recentException = exception;
            } else {
                recentException.setNext(exception);
                recentException = exception;
            }
            ++i2;
        }
        noCodes = null;
        return firstException;
    }

    private static ServiceException parseSE(Element element) {
        String errorMessage = element.getText();
        String code = element.getAttributeValue("code");
        return new ServiceException(errorMessage, code);
    }
}

