/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.FilteringIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    FeatureCollection<T, F> delegate;
    Filter filter;

    public FilteringFeatureCollection(FeatureCollection<T, F> delegate, Filter filter) {
        super(delegate);
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public FeatureIterator<F> features() {
        return new DelegateFeatureIterator<F>(this, this.iterator());
    }

    @Override
    public void close(FeatureIterator<F> close) {
        close.close();
    }

    @Override
    public Iterator<F> iterator() {
        return new FilteringIterator(this.delegate.iterator(), this.filter);
    }

    @Override
    public void close(Iterator<F> close) {
        FilteringIterator filtering = (FilteringIterator)close;
        this.delegate.close(filtering.getDelegate());
    }

    @Override
    public FeatureCollection<T, F> subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FeatureCollection<T, F> sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<F> i = this.iterator();
        try {
            while (i.hasNext()) {
                ++count;
                i.next();
            }
            int n = count;
            return n;
        }
        finally {
            this.close(i);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public Object[] toArray(Object[] a) {
        ArrayList<F> list = new ArrayList<F>();
        Iterator<F> i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object[] objectArray = list.toArray(a);
            return objectArray;
        }
        finally {
            this.close(i);
        }
    }

    @Override
    public boolean add(F o) {
        if (!this.filter.evaluate(o)) {
            return false;
        }
        return this.delegate.add(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o) && this.filter.evaluate(o);
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            changed |= this.add((Feature)i.next());
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public FeatureReader<T, F> reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference((Envelope)DataUtilities.bounds(this));
    }
}

