/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.Iterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ReTypingIterator
implements Iterator {
    Iterator delegate;
    SimpleFeatureType target;
    AttributeDescriptor[] types;
    SimpleFeatureBuilder builder;

    public ReTypingIterator(Iterator delegate, SimpleFeatureType source, SimpleFeatureType target) {
        this.delegate = delegate;
        this.target = target;
        this.types = this.typeAttributes(source, target);
        this.builder = new SimpleFeatureBuilder(target);
    }

    public Iterator getDelegate() {
        return this.delegate;
    }

    public void remove() {
        this.delegate.remove();
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        SimpleFeature next = (SimpleFeature)this.delegate.next();
        String id = next.getID();
        try {
            int i = 0;
            while (i < this.types.length) {
                String xpath = this.types[i].getLocalName();
                this.builder.add(next.getAttribute(xpath));
                ++i;
            }
            return this.builder.buildFeature(id);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException(e);
        }
    }

    protected AttributeDescriptor[] typeAttributes(SimpleFeatureType original, SimpleFeatureType target) {
        if (target.equals((Object)original)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (target.getAttributeCount() > original.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover requested type)");
        }
        AttributeDescriptor[] types = new AttributeDescriptor[target.getAttributeCount()];
        int i = 0;
        while (i < target.getAttributeCount()) {
            AttributeDescriptor attrib = target.getDescriptor(i);
            String xpath = attrib.getLocalName();
            types[i] = attrib;
            if (!attrib.equals(original.getDescriptor(xpath))) {
                throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover " + xpath + ")");
            }
            ++i;
        }
        return types;
    }
}

