/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureCollection
implements SimpleFeatureCollection {
    protected List<CollectionListener> listeners = new ArrayList<CollectionListener>();
    protected String id;
    protected SimpleFeatureType schema;
    protected final Set open = new HashSet();

    protected AbstractFeatureCollection(SimpleFeatureType memberType) {
        this.id = this.id == null ? "featureCollection" : this.id;
        this.schema = memberType;
    }

    public SimpleFeatureIterator features() {
        DelegateSimpleFeatureIterator iter = new DelegateSimpleFeatureIterator((FeatureCollection<SimpleFeatureType, SimpleFeature>)this, this.openIterator());
        this.getOpenIterators().add(iter);
        return iter;
    }

    public final void close(Iterator close) {
        if (close == null) {
            return;
        }
        try {
            try {
                this.closeIterator(close);
            }
            catch (Throwable throwable) {
                this.open.remove(close);
            }
        }
        finally {
            this.open.remove(close);
        }
    }

    public void close(FeatureIterator<SimpleFeature> close) {
        if (close != null) {
            close.close();
        }
    }

    protected abstract Iterator<SimpleFeature> openIterator();

    protected abstract void closeIterator(Iterator<SimpleFeature> var1);

    public void purge() {
        Iterator i = this.open.iterator();
        while (i.hasNext()) {
            Object resource = i.next();
            if (!(resource instanceof Iterator)) continue;
            Iterator resourceIterator = (Iterator)resource;
            try {
                try {
                    this.closeIterator(resourceIterator);
                }
                catch (Throwable throwable) {
                    i.remove();
                    continue;
                }
            }
            catch (Throwable throwable) {
                i.remove();
                throw throwable;
            }
            i.remove();
        }
    }

    public abstract int size();

    public boolean add(SimpleFeature o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends SimpleFeature> c) {
        boolean modified = false;
        Iterator<? extends SimpleFeature> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (!this.add(e.next())) continue;
                modified = true;
            }
        }
        finally {
            if (c instanceof FeatureCollection) {
                FeatureCollection other = (FeatureCollection)c;
                other.close(e);
            }
        }
        return modified;
    }

    public boolean addAll(FeatureCollection<? extends SimpleFeatureType, ? extends SimpleFeature> c) {
        boolean modified = false;
        FeatureIterator e = c.features();
        try {
            while (e.hasNext()) {
                if (!this.add((SimpleFeature)e.next())) continue;
                modified = true;
            }
        }
        finally {
            e.close();
        }
        return modified;
    }

    public void clear() {
        Iterator<SimpleFeature> e = this.iterator();
        try {
            while (e.hasNext()) {
                e.next();
                e.remove();
            }
        }
        finally {
            this.close(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(Object o) {
        e = null;
        try {
            block7: {
                e = this.iterator();
                if (o != null) ** GOTO lbl11
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    return true;
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    if (o.equals(e.next())) ** continue;
lbl11:
                    // 2 sources

                    ** while (e.hasNext())
                }
            }
            return false;
        }
        finally {
            this.close(e);
        }
    }

    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                return false;
            }
            return true;
        }
        finally {
            this.close(e);
        }
    }

    public final Set getOpenIterators() {
        return this.open;
    }

    public final Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> iterator = this.openIterator();
        this.getOpenIterators().add(iterator);
        return iterator;
    }

    public boolean isEmpty() {
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            boolean bl = !iterator.hasNext();
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean remove(Object o) {
        e = this.iterator();
        try {
            block7: {
                if (o != null) ** GOTO lbl13
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    e.remove();
lbl7:
                    // 2 sources

                    return true;
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    if (!o.equals(e.next())) continue;
                    e.remove();
                    ** continue;
lbl13:
                    // 2 sources

                    ** while (e.hasNext())
                }
            }
            return false;
        }
        finally {
            this.close(e);
        }
    }

    public final boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<SimpleFeature> e = this.iterator();
        try {
            while (e.hasNext()) {
                if (!c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            if (c instanceof FeatureCollection) {
                FeatureCollection other = (FeatureCollection)c;
                other.close(e);
            }
        }
    }

    public final boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<SimpleFeature> e = this.iterator();
        try {
            while (e.hasNext()) {
                if (c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            if (c instanceof FeatureCollection) {
                FeatureCollection other = (FeatureCollection)c;
                other.close(e);
            }
        }
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator<SimpleFeature> e = null;
        try {
            e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.close(e);
        }
    }

    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            T[] result = a;
            int i = 0;
            while (i < size) {
                result[i] = it.next();
                ++i;
            }
            if (a.length > size) {
                a[size] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            this.close(it);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        Iterator<SimpleFeature> iterator = null;
        if (progress == null) {
            progress = new NullProgressListener();
        }
        try {
            block10: {
                float position;
                float size;
                block9: {
                    size = this.size();
                    position = 0.0f;
                    progress.started();
                    iterator = this.iterator();
                    if (!true) break block9;
                    if (progress.isCanceled()) return;
                    if (!iterator.hasNext()) break block10;
                }
                do {
                    if (size > 0.0f) {
                        float f = position;
                        position = f + 1.0f;
                        progress.progress(f / size);
                    }
                    try {
                        SimpleFeature feature = iterator.next();
                        visitor.visit((Feature)feature);
                    }
                    catch (Exception erp) {
                        progress.exceptionOccurred((Throwable)erp);
                    }
                    if (progress.isCanceled()) return;
                } while (iterator.hasNext());
            }
            return;
        }
        finally {
            progress.complete();
            this.close(iterator);
        }
    }

    public SimpleFeatureCollection subList(Filter filter) {
        return new SubFeatureList((SimpleFeatureCollection)this, filter);
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return new SubFeatureList((SimpleFeatureCollection)this, order);
    }

    public String getID() {
        return this.id;
    }

    public final void addListener(CollectionListener listener) throws NullPointerException {
        this.listeners.add(listener);
    }

    public final void removeListener(CollectionListener listener) throws NullPointerException {
        this.listeners.remove(listener);
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public abstract ReferencedEnvelope getBounds();
}

