/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

public class CalcUtil {
    static Number sum(Number[] numbers) {
        Number newSum = (Number)CalcUtil.getObject(numbers);
        if (newSum == null) {
            return null;
        }
        if (newSum instanceof Integer) {
            int sum = 0;
            int i = 0;
            while (i < numbers.length) {
                int nextValue = numbers[i].intValue();
                sum += nextValue;
                ++i;
            }
            newSum = new Integer(sum);
        } else if (newSum instanceof Long) {
            long sum = 0L;
            int i = 0;
            while (i < numbers.length) {
                long nextValue = numbers[i].longValue();
                sum += nextValue;
                ++i;
            }
            newSum = new Long(sum);
        } else if (newSum instanceof Float) {
            float sum = 0.0f;
            int i = 0;
            while (i < numbers.length) {
                float nextValue = numbers[i].floatValue();
                sum += nextValue;
                ++i;
            }
            newSum = new Float(sum);
        } else if (newSum instanceof Double) {
            double sum = 0.0;
            int i = 0;
            while (i < numbers.length) {
                double nextValue = numbers[i].doubleValue();
                sum += nextValue;
                ++i;
            }
            newSum = new Double(sum);
        } else {
            return null;
        }
        return newSum;
    }

    static Number divide(Number num1, Number num2) {
        Object[] both = new Number[]{num1, num2};
        Number division = (Number)CalcUtil.getObject(both);
        if (division == null) {
            return null;
        }
        if (division instanceof Integer) {
            return new Double(num1.doubleValue() / num2.doubleValue());
        }
        if (division instanceof Long) {
            return new Long(num1.longValue() / num2.longValue());
        }
        if (division instanceof Float) {
            return new Float(num1.floatValue() / num2.floatValue());
        }
        if (division instanceof Double) {
            return new Double(num1.doubleValue() / num2.doubleValue());
        }
        return null;
    }

    static Number average(Number[] numbers) {
        Number sum = CalcUtil.sum(numbers);
        return CalcUtil.divide(sum, new Integer(numbers.length));
    }

    static Class bestClass(Object[] objects) {
        boolean hasInt = false;
        boolean hasFloat = false;
        boolean hasLong = false;
        boolean hasDouble = false;
        boolean hasString = false;
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof Double) {
                hasDouble = true;
            } else if (objects[i] instanceof Float) {
                hasFloat = true;
            } else if (objects[i] instanceof Long) {
                hasLong = true;
            } else if (objects[i] instanceof Integer) {
                hasInt = true;
            } else if (objects[i] instanceof String) {
                hasString = true;
            }
            ++i;
        }
        if (hasString) {
            return String.class;
        }
        if (hasDouble) {
            return Double.class;
        }
        if (hasFloat) {
            return Float.class;
        }
        if (hasLong) {
            return Long.class;
        }
        if (hasInt) {
            return Integer.class;
        }
        return null;
    }

    static Object convert(Object var, Class type) {
        if (var instanceof Number) {
            Number newNum = (Number)var;
            if (type == Integer.class) {
                return new Integer(newNum.intValue());
            }
            if (type == Long.class) {
                return new Long(newNum.longValue());
            }
            if (type == Float.class) {
                return new Float(newNum.floatValue());
            }
            if (type == Double.class) {
                return new Double(newNum.doubleValue());
            }
            if (type == String.class) {
                return new String(newNum.toString());
            }
        } else {
            if (type == Integer.class) {
                return new Integer((Integer)var);
            }
            if (type == Long.class) {
                return new Long((Long)var);
            }
            if (type == Float.class) {
                return new Float(((Float)var).floatValue());
            }
            if (type == Double.class) {
                return new Double((Double)var);
            }
            if (type == String.class) {
                return new String(var.toString());
            }
        }
        return null;
    }

    static Object convert(Object[] objects, Object var) {
        Object newVar = CalcUtil.getObject(objects);
        if (newVar instanceof Number) {
            Number newNum = (Number)var;
            if (newVar instanceof Integer) {
                return new Integer(newNum.intValue());
            }
            if (newVar instanceof Long) {
                return new Long(newNum.longValue());
            }
            if (newVar instanceof Float) {
                return new Float(newNum.floatValue());
            }
            if (newVar instanceof Double) {
                return new Double(newNum.doubleValue());
            }
            return null;
        }
        if (newVar instanceof String) {
            return new String((String)newVar);
        }
        return null;
    }

    static Object getObject(Object[] objects) {
        Class bestClass = CalcUtil.bestClass(objects);
        if (bestClass == String.class) {
            return new String("");
        }
        if (bestClass == Double.class) {
            return new Double(0.0);
        }
        if (bestClass == Float.class) {
            return new Float(0.0f);
        }
        if (bestClass == Long.class) {
            return new Long(0L);
        }
        if (bestClass == Integer.class) {
            return new Integer(0);
        }
        return null;
    }

    static int compare(Comparable val1, Comparable val2) {
        if (val1.getClass() == val2.getClass()) {
            return val1.compareTo(val2);
        }
        Object[] objects = new Object[]{val1, val2};
        Class bestClass = CalcUtil.bestClass(objects);
        if (bestClass != val1.getClass()) {
            val1 = (Comparable)CalcUtil.convert(val1, bestClass);
        }
        if (bestClass != val2.getClass()) {
            val2 = (Comparable)CalcUtil.convert(val2, bestClass);
        }
        return val1.compareTo(val2);
    }
}

