/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class SumVisitor
implements FeatureCalc {
    private Expression expr;
    SumStrategy strategy;

    public SumVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        AttributeDescriptor attributeType = type.getDescriptor(attributeTypeIndex);
        this.expr = factory.property(attributeType.getLocalName());
        SumVisitor.createStrategy(attributeType.getType().getBinding());
    }

    public SumVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        AttributeDescriptor attributeType = type.getDescriptor(attrName);
        this.expr = factory.property(attributeType.getLocalName());
        SumVisitor.createStrategy(attributeType.getType().getBinding());
    }

    public SumVisitor(Expression expr) throws IllegalFilterException {
        this.expr = expr;
    }

    public void init(SimpleFeatureCollection collection) {
    }

    private static SumStrategy createStrategy(Class type) {
        if (type == Integer.class) {
            return new IntegerSumStrategy();
        }
        if (type == Long.class) {
            return new LongSumStrategy();
        }
        if (type == Float.class) {
            return new FloatSumStrategy();
        }
        if (Number.class.isAssignableFrom(type)) {
            return new DoubleSumStrategy();
        }
        return null;
    }

    public void visit(SimpleFeature feature) {
        this.visit(feature);
    }

    public void visit(Feature feature) {
        Object value = this.expr.evaluate((Object)feature);
        if (this.strategy == null) {
            this.strategy = SumVisitor.createStrategy(value.getClass());
        }
        this.strategy.add(value);
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Object getSum() {
        return this.strategy.getResult();
    }

    public void setValue(Object newSum) {
        this.strategy = SumVisitor.createStrategy(newSum.getClass());
        this.strategy.add(newSum);
    }

    public void reset() {
        this.strategy = null;
    }

    public CalcResult getResult() {
        if (this.strategy == null) {
            return CalcResult.NULL_RESULT;
        }
        return new SumResult(this.strategy);
    }

    static class DoubleSumStrategy
    implements SumStrategy {
        double number = 0.0;

        DoubleSumStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).doubleValue();
        }

        public Object getResult() {
            return new Double(this.number);
        }
    }

    static class FloatSumStrategy
    implements SumStrategy {
        float number = 0.0f;

        FloatSumStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).floatValue();
        }

        public Object getResult() {
            return new Float(this.number);
        }
    }

    static class IntegerSumStrategy
    implements SumStrategy {
        int number = 0;

        IntegerSumStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).intValue();
        }

        public Object getResult() {
            return new Integer(this.number);
        }
    }

    static class LongSumStrategy
    implements SumStrategy {
        long number = 0L;

        LongSumStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).longValue();
        }

        public Object getResult() {
            return new Long(this.number);
        }
    }

    public static class SumResult
    extends AbstractCalcResult {
        private SumStrategy sum;

        public SumResult(SumStrategy newSum) {
            this.sum = newSum;
        }

        public Object getValue() {
            return this.sum.getResult();
        }

        public boolean isCompatible(CalcResult targetResults) {
            if (targetResults == CalcResult.NULL_RESULT) {
                return true;
            }
            if (targetResults instanceof SumResult) {
                return true;
            }
            return targetResults instanceof CountVisitor.CountResult;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof SumResult) {
                Object[] sums = new Number[]{(Number)this.sum.getResult(), (Number)resultsToAdd.getValue()};
                SumStrategy newSum = SumVisitor.createStrategy(CalcUtil.getObject(sums).getClass());
                newSum.add(sums[0]);
                newSum.add(sums[1]);
                return new SumResult(newSum);
            }
            if (resultsToAdd instanceof CountVisitor.CountResult) {
                int count = resultsToAdd.toInt();
                AverageVisitor.AverageResult newResult = new AverageVisitor.AverageResult(count, this.sum.getResult());
                return newResult;
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }

    static interface SumStrategy {
        public void add(Object var1);

        public Object getResult();
    }
}

