/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.filter.FunctionExpressionImpl;
import org.opengis.filter.expression.Expression;

public class AreaFunction
extends FunctionExpressionImpl {
    public AreaFunction() {
        super("Area");
    }

    public Object evaluate(Object feature) {
        Expression geom = (Expression)this.getParameters().get(0);
        Geometry g = (Geometry)geom.evaluate(feature);
        return new Double(this.getArea(g));
    }

    public int getArgCount() {
        return 1;
    }

    protected double getArea(GeometryCollection geometryCollection1) {
        double area = 0.0;
        int numberOfGeometries1 = geometryCollection1.getNumGeometries();
        int i = 0;
        while (i < numberOfGeometries1) {
            area += this.getArea(geometryCollection1.getGeometryN(i));
            ++i;
        }
        return area;
    }

    protected double getPerimeter(GeometryCollection geometryCollection) {
        double perimeter = 0.0;
        int numberOfGeometries = geometryCollection.getNumGeometries();
        int i = 0;
        while (i < numberOfGeometries) {
            perimeter += this.getPerimeter(geometryCollection.getGeometryN(i));
            ++i;
        }
        return perimeter;
    }

    public double getArea(Geometry geometry) {
        double area = 0.0;
        area = geometry instanceof GeometryCollection ? (area += this.getArea((GeometryCollection)geometry)) : (geometry instanceof MultiPolygon ? (area += this.getArea((MultiPolygon)geometry)) : (geometry instanceof Polygon ? (area += this.getArea((Polygon)geometry)) : (area += 0.0)));
        return area;
    }

    public double getPerimeter(Geometry geometry) {
        double perimeter = 0.0;
        perimeter = geometry instanceof GeometryCollection ? (perimeter += this.getPerimeter((GeometryCollection)geometry)) : (geometry instanceof MultiPolygon ? (perimeter += this.getPerimeter((GeometryCollection)((MultiPolygon)geometry))) : (geometry instanceof Polygon ? (perimeter += this.getPerimeter((Polygon)geometry)) : (geometry instanceof MultiLineString ? (perimeter += this.getPerimeter((MultiLineString)geometry)) : (geometry instanceof LineString ? (perimeter += this.getPerimeter((LineString)geometry)) : (perimeter += 0.0)))));
        return perimeter;
    }

    protected double getArea(MultiPolygon multiPolygon) {
        double area = 0.0;
        int numberOfGeometries = multiPolygon.getNumGeometries();
        int i = 0;
        while (i < numberOfGeometries) {
            area += this.getArea(multiPolygon.getGeometryN(i));
            ++i;
        }
        return area;
    }

    protected double getperimeter(MultiPolygon multiPolygon) {
        double perimeter = 0.0;
        int numberOfGeometries = multiPolygon.getNumGeometries();
        int i = 0;
        while (i < numberOfGeometries) {
            perimeter += this.getPerimeter(multiPolygon.getGeometryN(i));
            ++i;
        }
        return perimeter;
    }

    protected double getArea(Polygon polygon) {
        double area = 0.0;
        double interiorArea = 0.0;
        Coordinate[] exteriorRingCoordinates = polygon.getExteriorRing().getCoordinates();
        int numberOfExteriorRingCoordinates = exteriorRingCoordinates.length;
        double minx = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < numberOfExteriorRingCoordinates) {
            minx = Math.min(minx, exteriorRingCoordinates[i].x);
            maxx = Math.max(maxx, exteriorRingCoordinates[i].x);
            miny = Math.min(miny, exteriorRingCoordinates[i].y);
            maxy = Math.max(maxy, exteriorRingCoordinates[i].y);
            ++i;
        }
        i = 0;
        while (i < numberOfExteriorRingCoordinates - 1) {
            area += (exteriorRingCoordinates[i + 1].x - minx - (exteriorRingCoordinates[i].x - minx)) * ((exteriorRingCoordinates[i + 1].y - miny + (exteriorRingCoordinates[i].y - miny)) / 2.0);
            ++i;
        }
        area = Math.abs(area);
        int numberOfInteriorRings = polygon.getNumInteriorRing();
        int i2 = 0;
        while (i2 < numberOfInteriorRings) {
            interiorArea = 0.0;
            Coordinate[] interiorRingCoordinates = polygon.getInteriorRingN(i2).getCoordinates();
            int numberOfInteriorRingCoordinates = interiorRingCoordinates.length;
            minx = Double.POSITIVE_INFINITY;
            maxx = Double.NEGATIVE_INFINITY;
            miny = Double.POSITIVE_INFINITY;
            maxy = Double.NEGATIVE_INFINITY;
            int j = 0;
            while (j < numberOfInteriorRingCoordinates) {
                minx = Math.min(minx, interiorRingCoordinates[j].x);
                maxx = Math.max(maxx, interiorRingCoordinates[j].x);
                miny = Math.min(miny, interiorRingCoordinates[j].y);
                maxy = Math.max(maxy, interiorRingCoordinates[j].y);
                ++j;
            }
            j = 0;
            while (j < numberOfInteriorRingCoordinates - 1) {
                interiorArea += (interiorRingCoordinates[j + 1].x - minx - (interiorRingCoordinates[j].x - minx)) * ((interiorRingCoordinates[j + 1].y - miny + (interiorRingCoordinates[j].y - miny)) / 2.0);
                ++j;
            }
            area -= Math.abs(interiorArea);
            ++i2;
        }
        return area;
    }

    protected double getPerimeter(Polygon polygon) {
        double perimeter = 0.0;
        LineString lineString = polygon.getExteriorRing();
        perimeter += this.getPerimeter(lineString);
        int numberOfHoles = polygon.getNumInteriorRing();
        int i = 0;
        while (i < numberOfHoles) {
            perimeter += this.getPerimeter(polygon.getInteriorRingN(i));
            ++i;
        }
        return perimeter;
    }

    protected double getPerimeter(MultiLineString multiLineString) {
        double perimeter = 0.0;
        int numberOfGeometries = multiLineString.getNumGeometries();
        int i = 0;
        while (i < numberOfGeometries) {
            perimeter += this.getPerimeter(multiLineString.getGeometryN(i));
            ++i;
        }
        return perimeter;
    }

    protected double getPerimeter(LineString lineString) {
        double perimeter = 0.0;
        int numberOfPoints = lineString.getNumPoints();
        Coordinate[] coordinates = lineString.getCoordinates();
        int i = 0;
        while (i < numberOfPoints - 1) {
            perimeter += coordinates[i].distance(coordinates[i + 1]);
            ++i;
        }
        return perimeter;
    }
}

