/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ExpressionDOMParser {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private FilterFactory2 ff;
    private static GeometryFactory gfac = new GeometryFactory();
    private static final int GML_BOX = 1;
    private static final int GML_POLYGON = 2;
    private static final int GML_LINESTRING = 3;
    private static final int GML_POINT = 4;
    private static final int NUM_BOX_COORDS = 5;

    private ExpressionDOMParser() {
        this(CommonFactoryFinder.getFilterFactory2(null));
        LOGGER.finer("made new logic factory");
    }

    public ExpressionDOMParser(FilterFactory2 factory) {
        this.ff = factory != null ? factory : CommonFactoryFinder.getFilterFactory2(null);
    }

    public void setFilterFactory(FilterFactory2 factory) {
        this.ff = factory;
    }

    public static Expression parseExpression(Node root) {
        ExpressionDOMParser parser = new ExpressionDOMParser();
        return parser.expression(root);
    }

    /*
     * Unable to fully structure code
     */
    public Expression expression(Node root) {
        block52: {
            ExpressionDOMParser.LOGGER.finer("parsingExpression " + root.getLocalName());
            if (root == null || root.getNodeType() != 1) {
                ExpressionDOMParser.LOGGER.finer("bad node input ");
                return null;
            }
            ExpressionDOMParser.LOGGER.finer("processing root " + root.getLocalName());
            child = root;
            v0 = childName = child.getLocalName() != null ? child.getLocalName() : child.getNodeName();
            if (childName.indexOf(58) != -1) {
                childName = childName.substring(childName.indexOf(58) + 1);
            }
            if (childName.equalsIgnoreCase("Literal")) {
                ExpressionDOMParser.LOGGER.finer("processing literal " + child);
                kidList = child.getChildNodes();
                ExpressionDOMParser.LOGGER.finest("literal elements (" + kidList.getLength() + ") " + kidList.toString());
                i = 0;
                while (i < kidList.getLength()) {
                    kid = kidList.item(i);
                    ExpressionDOMParser.LOGGER.finest("kid " + i + " " + kid);
                    if (kid == null) {
                        ExpressionDOMParser.LOGGER.finest("Skipping ");
                    } else {
                        if (kid.getNodeValue() == null) {
                            ExpressionDOMParser.LOGGER.finer("node " + kid.getNodeValue() + " namespace " + kid.getNamespaceURI());
                            ExpressionDOMParser.LOGGER.fine("a literal gml string?");
                            try {
                                geom = ExpressionDOMParser.parseGML(kid);
                                if (geom != null) {
                                    ExpressionDOMParser.LOGGER.finer("built a " + geom.getGeometryType() + " from gml");
                                    ExpressionDOMParser.LOGGER.finer("\tpoints: " + geom.getNumPoints());
                                } else {
                                    ExpressionDOMParser.LOGGER.finer("got a null geometry back from gml parser");
                                }
                                return this.ff.literal((Object)geom);
                            }
                            catch (IllegalFilterException ife) {
                                ExpressionDOMParser.LOGGER.warning("Problem building GML/JTS object: " + (Object)ife);
                                return null;
                            }
                        }
                        if (kid.getNodeValue().trim().length() == 0) {
                            ExpressionDOMParser.LOGGER.finest("empty text element");
                        } else {
                            nodeValue = kid.getNodeValue();
                            ExpressionDOMParser.LOGGER.finer("processing " + nodeValue);
                            try {
                                return this.ff.literal((Object)nodeValue);
                            }
                            catch (IllegalFilterException ife) {
                                ExpressionDOMParser.LOGGER.finer("Unable to build expression " + (Object)ife);
                                return null;
                            }
                        }
                    }
                    ++i;
                }
                return this.ff.literal((Object)"");
            }
            if (childName.equalsIgnoreCase("add")) {
                try {
                    ExpressionDOMParser.LOGGER.fine("processing an Add");
                    value = child.getFirstChild();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    ExpressionDOMParser.LOGGER.finer("add left value -> " + value + "<-");
                    left = ExpressionDOMParser.parseExpression(value);
                    value = value.getNextSibling();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    ExpressionDOMParser.LOGGER.finer("add right value -> " + value + "<-");
                    right = ExpressionDOMParser.parseExpression(value);
                    return this.ff.add(left, right);
                }
                catch (IllegalFilterException ife) {
                    ExpressionDOMParser.LOGGER.warning("Unable to build expression " + (Object)ife);
                    return null;
                }
            }
            if (childName.equalsIgnoreCase("sub")) {
                try {
                    value = child.getFirstChild();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    ExpressionDOMParser.LOGGER.finer("add left value -> " + value + "<-");
                    left = ExpressionDOMParser.parseExpression(value);
                    value = value.getNextSibling();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    ExpressionDOMParser.LOGGER.finer("add right value -> " + value + "<-");
                    right = ExpressionDOMParser.parseExpression(value);
                    return this.ff.subtract(left, right);
                }
                catch (IllegalFilterException ife) {
                    ExpressionDOMParser.LOGGER.warning("Unable to build expression " + (Object)ife);
                    return null;
                }
            }
            if (childName.equalsIgnoreCase("mul")) {
                try {
                    value = child.getFirstChild();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    ExpressionDOMParser.LOGGER.finer("add left value -> " + value + "<-");
                    left = ExpressionDOMParser.parseExpression(value);
                    value = value.getNextSibling();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    ExpressionDOMParser.LOGGER.finer("add right value -> " + value + "<-");
                    right = ExpressionDOMParser.parseExpression(value);
                    return this.ff.multiply(left, right);
                }
                catch (IllegalFilterException ife) {
                    ExpressionDOMParser.LOGGER.warning("Unable to build expression " + (Object)ife);
                    return null;
                }
            }
            if (childName.equalsIgnoreCase("div")) {
                try {
                    value = child.getFirstChild();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    ExpressionDOMParser.LOGGER.finer("add left value -> " + value + "<-");
                    left = ExpressionDOMParser.parseExpression(value);
                    value = value.getNextSibling();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    ExpressionDOMParser.LOGGER.finer("add right value -> " + value + "<-");
                    right = ExpressionDOMParser.parseExpression(value);
                    return this.ff.divide(left, right);
                }
                catch (IllegalFilterException ife) {
                    ExpressionDOMParser.LOGGER.warning("Unable to build expression " + (Object)ife);
                    return null;
                }
            }
            if (childName.equalsIgnoreCase("PropertyName")) {
                try {
                    value = child.getFirstChild().getNodeValue();
                    value = value != null ? value.trim() : value;
                    attribute = this.ff.property(value);
                    return attribute;
                }
                catch (IllegalFilterException ife) {
                    ExpressionDOMParser.LOGGER.warning("Unable to build expression: " + (Object)ife);
                    return null;
                }
            }
            if (!childName.equalsIgnoreCase("Function")) break block52;
            param = (Element)child;
            map = param.getAttributes();
            funcName = null;
            k = 0;
            while (k < map.getLength()) {
                res = map.item(k).getNodeValue();
                name = map.item(k).getLocalName();
                if (name == null) {
                    name = map.item(k).getNodeName();
                }
                if (name.indexOf(58) != -1) {
                    name = name.substring(name.indexOf(58) + 1);
                }
                ExpressionDOMParser.LOGGER.fine("attribute " + name + " with value of " + res);
                if (name.equalsIgnoreCase("name")) {
                    funcName = res;
                }
                ++k;
            }
            if (funcName == null) {
                ExpressionDOMParser.LOGGER.severe("failed to find a function name in " + child);
                return null;
            }
            args = new ArrayList<Expression>();
            value = child.getFirstChild();
            ** GOTO lbl158
            while ((value = value.getNextSibling()) != null) {
                while (value.getNodeType() == 1) {
                    args.add(ExpressionDOMParser.parseExpression(value));
                    value = value.getNextSibling();
lbl158:
                    // 2 sources

                    if (value != null) continue;
                }
            }
            array = args.toArray(new Expression[0]);
            return this.ff.function(funcName, array);
        }
        if (child.getNodeType() == 3) {
            ExpressionDOMParser.LOGGER.finer("processing a text node " + root.getNodeValue());
            nodeValue = root.getNodeValue();
            ExpressionDOMParser.LOGGER.finer("Text name " + nodeValue);
            try {
                try {
                    intLiteral = new Integer(nodeValue);
                    return this.ff.literal((Object)intLiteral);
                }
                catch (NumberFormatException intLiteral) {
                    try {
                        doubleLit = new Double(nodeValue);
                        return this.ff.literal((Object)doubleLit);
                    }
                    catch (NumberFormatException doubleLit) {
                        return this.ff.literal((Object)nodeValue);
                    }
                }
            }
            catch (IllegalFilterException ife) {
                ExpressionDOMParser.LOGGER.finer("Unable to build expression " + (Object)ife);
            }
        }
        return null;
    }

    public static Geometry parseGML(Node root) {
        ExpressionDOMParser parser = new ExpressionDOMParser();
        return parser.gml(root);
    }

    public Geometry gml(Node root) {
        LOGGER.finer("processing gml " + root);
        int type = 0;
        Node child = root;
        String childName = child.getNodeName();
        if (childName == null) {
            childName = child.getLocalName();
        }
        if (!childName.startsWith("gml:")) {
            childName = "gml:" + childName;
        }
        if (childName.equalsIgnoreCase("gml:box")) {
            type = 1;
            List coordList = ExpressionDOMParser.parseCoords(child);
            Envelope env = new Envelope();
            int i = 0;
            while (i < coordList.size()) {
                env.expandToInclude((Coordinate)coordList.get(i));
                ++i;
            }
            Coordinate[] coords = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
            LinearRing ring = null;
            try {
                ring = gfac.createLinearRing(coords);
            }
            catch (TopologyException tope) {
                LOGGER.fine("Topology Exception in GMLBox" + (Object)((Object)tope));
                return null;
            }
            return gfac.createPolygon(ring, null);
        }
        if (childName.equalsIgnoreCase("gml:polygonmember") || childName.equalsIgnoreCase("gml:pointmember") || childName.equalsIgnoreCase("gml:linestringmember") || childName.equalsIgnoreCase("gml:linearringmember")) {
            int i = 0;
            while (i < child.getChildNodes().getLength()) {
                Node newChild = child.getChildNodes().item(i);
                if (newChild.getNodeType() == 1) {
                    childName = newChild.getNodeName();
                    if (!childName.startsWith("gml:")) {
                        childName = "gml:" + childName;
                    }
                    root = newChild;
                    child = newChild;
                    break;
                }
                ++i;
            }
        }
        if (childName.equalsIgnoreCase("gml:polygon")) {
            LOGGER.finer("polygon");
            type = 2;
            LinearRing outer = null;
            ArrayList<LinearRing> inner = new ArrayList<LinearRing>();
            NodeList kids = root.getChildNodes();
            int i = 0;
            while (i < kids.getLength()) {
                Node kid = kids.item(i);
                LOGGER.finer("doing " + kid);
                String kidName = kid.getNodeName();
                if (kidName == null) {
                    kidName = child.getLocalName();
                }
                if (!kidName.startsWith("gml:")) {
                    kidName = "gml:" + kidName;
                }
                if (kidName.equalsIgnoreCase("gml:outerBoundaryIs")) {
                    outer = (LinearRing)ExpressionDOMParser.parseGML(kid);
                }
                if (kidName.equalsIgnoreCase("gml:innerBoundaryIs")) {
                    inner.add((LinearRing)ExpressionDOMParser.parseGML(kid));
                }
                ++i;
            }
            if (inner.size() > 0) {
                return gfac.createPolygon(outer, inner.toArray(new LinearRing[0]));
            }
            return gfac.createPolygon(outer, null);
        }
        if (childName.equalsIgnoreCase("gml:outerBoundaryIs") || childName.equalsIgnoreCase("gml:innerBoundaryIs")) {
            LOGGER.finer("Boundary layer");
            NodeList kids = ((Element)child).getElementsByTagName("gml:LinearRing");
            if (kids.getLength() == 0) {
                kids = ((Element)child).getElementsByTagName("LinearRing");
            }
            return ExpressionDOMParser.parseGML(kids.item(0));
        }
        if (childName.equalsIgnoreCase("gml:linearRing")) {
            LOGGER.finer("LinearRing");
            List coordList = ExpressionDOMParser.parseCoords(child);
            LinearRing ring = null;
            try {
                ring = gfac.createLinearRing(coordList.toArray(new Coordinate[0]));
            }
            catch (TopologyException te) {
                LOGGER.finer("Topology Exception build linear ring: " + (Object)((Object)te));
                return null;
            }
            return ring;
        }
        if (childName.equalsIgnoreCase("gml:linestring")) {
            LOGGER.finer("linestring");
            type = 3;
            List coordList = ExpressionDOMParser.parseCoords(child);
            LineString line = null;
            line = gfac.createLineString(coordList.toArray(new Coordinate[0]));
            return line;
        }
        if (childName.equalsIgnoreCase("gml:point")) {
            LOGGER.finer("point");
            type = 4;
            List coordList = ExpressionDOMParser.parseCoords(child);
            Point point = null;
            point = gfac.createPoint((Coordinate)coordList.get(0));
            return point;
        }
        if (childName.toLowerCase().startsWith("gml:multipolygon") || childName.toLowerCase().startsWith("gml:multilinestring") || childName.toLowerCase().startsWith("gml:multipoint")) {
            ArrayList<Geometry> multi = new ArrayList<Geometry>();
            NodeList kids = child.getChildNodes();
            int i = 0;
            while (i < kids.getLength()) {
                if (kids.item(i).getNodeType() == 1) {
                    multi.add(ExpressionDOMParser.parseGML(kids.item(i)));
                }
                ++i;
            }
            if (childName.toLowerCase().startsWith("gml:multipolygon")) {
                LOGGER.finer("MultiPolygon");
                return gfac.createMultiPolygon(multi.toArray(new Polygon[0]));
            }
            if (childName.toLowerCase().startsWith("gml:multilinestring")) {
                LOGGER.finer("MultiLineString");
                return gfac.createMultiLineString(multi.toArray(new LineString[0]));
            }
            LOGGER.finer("MultiPoint");
            return gfac.createMultiPoint(multi.toArray(new Point[0]));
        }
        return null;
    }

    public static List parseCoords(Node root) {
        ExpressionDOMParser parser = new ExpressionDOMParser();
        return parser.coords(root);
    }

    public List coords(Node root) {
        LOGGER.finer("parsing coordinate(s) " + root);
        ArrayList<Coordinate> clist = new ArrayList<Coordinate>();
        NodeList kids = root.getChildNodes();
        int i = 0;
        while (i < kids.getLength()) {
            Node child = kids.item(i);
            LOGGER.finer("doing " + child);
            String childName = child.getNodeName();
            if (childName == null) {
                childName = child.getLocalName();
            }
            if (!childName.startsWith("gml:")) {
                childName = "gml:" + childName;
            }
            if (childName.equalsIgnoreCase("gml:coord")) {
                Coordinate c = new Coordinate();
                NodeList grandChildren = child.getChildNodes();
                int t = 0;
                while (t < grandChildren.getLength()) {
                    Node grandChild = grandChildren.item(t);
                    String grandChildName = grandChild.getNodeName();
                    if (grandChildName == null) {
                        grandChildName = grandChild.getLocalName();
                    }
                    if (!grandChildName.startsWith("gml:")) {
                        grandChildName = "gml:" + grandChildName;
                    }
                    if (grandChildName.equalsIgnoreCase("gml:x")) {
                        c.x = Double.parseDouble(grandChild.getChildNodes().item(0).getNodeValue().trim());
                    } else if (grandChildName.equalsIgnoreCase("gml:y")) {
                        c.y = Double.parseDouble(grandChild.getChildNodes().item(0).getNodeValue().trim());
                    } else if (grandChildName.equalsIgnoreCase("gml:z")) {
                        c.z = Double.parseDouble(grandChild.getChildNodes().item(0).getNodeValue().trim());
                    }
                    ++t;
                }
                clist.add(c);
            }
            if (childName.equalsIgnoreCase("gml:coordinates")) {
                LOGGER.finer("coordinates " + child.getFirstChild().getNodeValue());
                NodeList grandKids = child.getChildNodes();
                int k = 0;
                while (k < grandKids.getLength()) {
                    Node grandKid = grandKids.item(k);
                    if (grandKid.getNodeValue() != null && grandKid.getNodeValue().trim().length() != 0) {
                        String outer = grandKid.getNodeValue().trim();
                        StringTokenizer ost = new StringTokenizer(outer, " \n\t");
                        while (ost.hasMoreTokens()) {
                            String internal = ost.nextToken();
                            StringTokenizer ist = new StringTokenizer(internal, ",");
                            double xCoord = Double.parseDouble(ist.nextToken());
                            double yCoord = Double.parseDouble(ist.nextToken());
                            double zCoord = Double.NaN;
                            if (ist.hasMoreTokens()) {
                                zCoord = Double.parseDouble(ist.nextToken());
                            }
                            clist.add(new Coordinate(xCoord, yCoord, zCoord));
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        return clist;
    }
}

