/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FilterDOMParser {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private static final FilterFactory2 FILTER_FACT = CommonFactoryFinder.getFilterFactory2(null);
    private static final int NUM_BETWEEN_CHILDREN = 3;
    private static Map comparisions = new HashMap();
    private static Map spatial = new HashMap();
    private static Map logical = new HashMap();

    static {
        comparisions.put("PropertyIsEqualTo", new Integer(14));
        comparisions.put("PropertyIsNotEqualTo", new Integer(23));
        comparisions.put("PropertyIsGreaterThan", new Integer(16));
        comparisions.put("PropertyIsGreaterThanOrEqualTo", new Integer(18));
        comparisions.put("PropertyIsLessThan", new Integer(15));
        comparisions.put("PropertyIsLessThanOrEqualTo", new Integer(17));
        comparisions.put("PropertyIsLike", new Integer(20));
        comparisions.put("PropertyIsNull", new Integer(21));
        comparisions.put("PropertyIsBetween", new Integer(19));
        comparisions.put("FeatureId", new Integer(22));
        spatial.put("Equals", new Integer(5));
        spatial.put("Disjoint", new Integer(6));
        spatial.put("Intersects", new Integer(7));
        spatial.put("Touches", new Integer(8));
        spatial.put("Crosses", new Integer(9));
        spatial.put("Within", new Integer(10));
        spatial.put("Contains", new Integer(11));
        spatial.put("Overlaps", new Integer(12));
        spatial.put("BBOX", new Integer(4));
        spatial.put("Beyond", new Integer(13));
        spatial.put("DWithin", new Integer(24));
        logical.put("And", new Integer(2));
        logical.put("Or", new Integer(1));
        logical.put("Not", new Integer(3));
    }

    private FilterDOMParser() {
    }

    public static Filter parseFilter(Node root) {
        LOGGER.finer("parsingFilter " + root.getLocalName());
        if (root == null || root.getNodeType() != 1) {
            LOGGER.finest("bad node input ");
            return null;
        }
        LOGGER.finest("processing root " + root.getLocalName() + " " + root.getNodeName());
        Node child = root;
        String childName = child.getLocalName();
        if (childName == null) {
            childName = child.getNodeName();
        }
        if (childName.indexOf(58) != -1) {
            childName = childName.substring(childName.indexOf(58) + 1);
        }
        LOGGER.finest("looking up " + childName);
        if (comparisions.containsKey(childName)) {
            short type;
            block89: {
                LOGGER.finer("a comparision filter " + childName);
                type = ((Integer)comparisions.get(childName)).shortValue();
                LOGGER.finer("type is " + type);
                if (type == 22) {
                    HashSet<FeatureId> ids = new HashSet<FeatureId>();
                    Element fidElement = (Element)child;
                    ids.add(FILTER_FACT.featureId(fidElement.getAttribute("fid")));
                    Node sibling = fidElement.getNextSibling();
                    while (sibling != null) {
                        LOGGER.finer("Parsing another FidFilter");
                        if (sibling.getNodeType() == 1) {
                            fidElement = (Element)sibling;
                            String fidElementName = fidElement.getLocalName();
                            if (fidElementName == null) {
                                fidElementName = fidElement.getNodeName();
                            }
                            if (fidElementName.indexOf(58) != -1) {
                                fidElementName = fidElementName.substring(fidElementName.indexOf(58) + 1);
                            }
                            if ("FeatureId".equals(fidElementName)) {
                                ids.add(FILTER_FACT.featureId(fidElement.getAttribute("fid")));
                            }
                        }
                        sibling = sibling.getNextSibling();
                    }
                    return FILTER_FACT.id(ids);
                }
                if (type == 19) {
                    NodeList kids = child.getChildNodes();
                    if (kids.getLength() < 3) {
                        throw new IllegalFilterException("wrong number of children in Between filter: expected 3 got " + kids.getLength());
                    }
                    Node value = child.getFirstChild();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    LOGGER.finer("add middle value -> " + value + "<-");
                    Expression middle = ExpressionDOMParser.parseExpression(value);
                    Expression lower = null;
                    Expression upper = null;
                    int i = 0;
                    while (i < kids.getLength()) {
                        String kidName;
                        Node kid = kids.item(i);
                        String string = kidName = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                        if (kidName.indexOf(58) != -1) {
                            kidName = kidName.substring(kidName.indexOf(58) + 1);
                        }
                        if (kidName.equalsIgnoreCase("LowerBoundary")) {
                            value = kid.getFirstChild();
                            while (value.getNodeType() != 1) {
                                value = value.getNextSibling();
                            }
                            LOGGER.finer("add left value -> " + value + "<-");
                            lower = ExpressionDOMParser.parseExpression(value);
                        }
                        if (kidName.equalsIgnoreCase("UpperBoundary")) {
                            value = kid.getFirstChild();
                            while (value.getNodeType() != 1) {
                                value = value.getNextSibling();
                            }
                            LOGGER.finer("add right value -> " + value + "<-");
                            upper = ExpressionDOMParser.parseExpression(value);
                        }
                        ++i;
                    }
                    return FILTER_FACT.between(middle, lower, upper);
                }
                if (type != 20) break block89;
                String wildcard = null;
                String single = null;
                String escape = null;
                String pattern = null;
                Object value = null;
                NodeList map = child.getChildNodes();
                int i = 0;
                while (i < map.getLength()) {
                    Node kid = map.item(i);
                    if (kid != null && kid.getNodeType() == 1) {
                        String res;
                        String string = res = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                        if (res.indexOf(58) != -1) {
                            res = res.substring(res.indexOf(58) + 1);
                        }
                        if (res.equalsIgnoreCase("PropertyName")) {
                            value = ExpressionDOMParser.parseExpression(kid);
                        }
                        if (res.equalsIgnoreCase("Literal")) {
                            pattern = ExpressionDOMParser.parseExpression(kid).toString();
                        }
                    }
                    ++i;
                }
                NamedNodeMap kids = child.getAttributes();
                int i2 = 0;
                while (i2 < kids.getLength()) {
                    String res;
                    Node kid = kids.item(i2);
                    String string = res = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                    if (res.indexOf(58) != -1) {
                        res = res.substring(res.indexOf(58) + 1);
                    }
                    if (res.equalsIgnoreCase("wildCard")) {
                        wildcard = kid.getNodeValue();
                    }
                    if (res.equalsIgnoreCase("singleChar")) {
                        single = kid.getNodeValue();
                    }
                    if (res.equalsIgnoreCase("escapeChar") || res.equalsIgnoreCase("escape")) {
                        escape = kid.getNodeValue();
                    }
                    ++i2;
                }
                if (wildcard != null && single != null && escape != null && pattern != null) {
                    LOGGER.finer("Building like filter " + value.toString() + "\n" + pattern + " " + wildcard + " " + single + " " + escape);
                    return FILTER_FACT.like((Expression)value, pattern, wildcard, single, escape);
                }
                LOGGER.finer("Problem building like filter\n" + pattern + " " + wildcard + " " + single + " " + escape);
                return null;
            }
            try {
                if (type == 21) {
                    return FilterDOMParser.parseNullFilter(child);
                }
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add left value -> " + value + "<-");
                Expression left = ExpressionDOMParser.parseExpression(value);
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add right value -> " + value + "<-");
                Expression right = ExpressionDOMParser.parseExpression(value);
                switch (type) {
                    case 14: {
                        return FILTER_FACT.equals(left, right);
                    }
                    case 16: {
                        return FILTER_FACT.greater(left, right);
                    }
                    case 18: {
                        return FILTER_FACT.greaterOrEqual(left, right);
                    }
                    case 15: {
                        return FILTER_FACT.less(left, right);
                    }
                    case 17: {
                        return FILTER_FACT.lessOrEqual(left, right);
                    }
                    case 23: {
                        return FILTER_FACT.notEqual(left, right, true);
                    }
                }
                LOGGER.warning("Unable to build filter for " + childName);
                return null;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build filter: " + (Object)((Object)ife));
                return null;
            }
        }
        if (spatial.containsKey(childName)) {
            LOGGER.finest("a spatial filter " + childName);
            try {
                Expression right;
                String valueName;
                short type = ((Integer)spatial.get(childName)).shortValue();
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add left value -> " + value + "<-");
                Expression left = ExpressionDOMParser.parseExpression(value);
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add right value -> " + value + "<-");
                String string = valueName = value.getLocalName() != null ? value.getLocalName() : value.getNodeName();
                if (valueName.indexOf(58) != -1) {
                    valueName = valueName.substring(valueName.indexOf(58) + 1);
                }
                Node nextNode = value.getNextSibling();
                if (!valueName.equalsIgnoreCase("Literal") && !valueName.equalsIgnoreCase("propertyname")) {
                    Element literal = value.getOwnerDocument().createElement("literal");
                    literal.appendChild(value);
                    LOGGER.finest("Built new literal " + literal);
                    right = ExpressionDOMParser.parseExpression(literal);
                } else {
                    right = ExpressionDOMParser.parseExpression(value);
                }
                String units = null;
                String nodeName = null;
                switch (type) {
                    case 5: {
                        return FILTER_FACT.equal(left, right);
                    }
                    case 6: {
                        return FILTER_FACT.disjoint(left, right);
                    }
                    case 7: {
                        return FILTER_FACT.intersects(left, right);
                    }
                    case 8: {
                        return FILTER_FACT.touches(left, right);
                    }
                    case 9: {
                        return FILTER_FACT.touches(left, right);
                    }
                    case 10: {
                        return FILTER_FACT.within(left, right);
                    }
                    case 11: {
                        return FILTER_FACT.contains(left, right);
                    }
                    case 12: {
                        return FILTER_FACT.overlaps(left, right);
                    }
                    case 24: {
                        value = nextNode;
                        while (value != null && value.getNodeType() != 1) {
                            value = value.getNextSibling();
                        }
                        if (value == null) {
                            throw new IllegalFilterException("DWithin is missing the Distance element");
                        }
                        nodeName = value.getNodeName();
                        if (nodeName.indexOf(58) > 0) {
                            nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
                        }
                        if (!"Distance".equals(nodeName)) {
                            throw new IllegalFilterException("Parsing DWithin, was expecting to find Distance but found " + value.getLocalName());
                        }
                        double distance = Double.parseDouble(value.getTextContent());
                        if (value.getAttributes().getNamedItem("units") != null) {
                            units = value.getAttributes().getNamedItem("units").getTextContent();
                        }
                        return FILTER_FACT.dwithin(left, right, distance, units);
                    }
                    case 13: {
                        value = nextNode;
                        while (value != null && value.getNodeType() != 1) {
                            value = value.getNextSibling();
                        }
                        if (value == null) {
                            throw new IllegalFilterException("Beyond is missing the Distance element");
                        }
                        nodeName = value.getNodeName();
                        if (nodeName.indexOf(58) > 0) {
                            nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
                        }
                        if (!"Distance".equals(nodeName)) {
                            throw new IllegalFilterException("Parsing Beyond, was expecting to find Distance but found " + value.getLocalName());
                        }
                        double distance = Double.parseDouble(value.getTextContent());
                        if (value.getAttributes().getNamedItem("units") != null) {
                            units = value.getAttributes().getNamedItem("units").getTextContent();
                        }
                        return FILTER_FACT.beyond(left, right, distance, units);
                    }
                    case 4: {
                        Literal literal = (Literal)right;
                        Object obj = literal.getValue();
                        ReferencedEnvelope bbox = null;
                        if (obj instanceof Geometry) {
                            bbox = JTS.toEnvelope((Geometry)((Geometry)obj));
                        } else if (obj instanceof ReferencedEnvelope) {
                            bbox = (ReferencedEnvelope)obj;
                        } else if (obj instanceof Envelope) {
                            bbox = new ReferencedEnvelope((Envelope)obj, null);
                        }
                        return FILTER_FACT.bbox(left, (BoundingBox)bbox);
                    }
                }
                LOGGER.warning("Unable to build filter: " + childName);
                return null;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build filter: " + (Object)((Object)ife));
                return null;
            }
        }
        if (logical.containsKey(childName)) {
            LOGGER.finest("a logical filter " + childName);
            try {
                ArrayList<Filter> children = new ArrayList<Filter>();
                NodeList map = child.getChildNodes();
                int i = 0;
                while (i < map.getLength()) {
                    Node kid = map.item(i);
                    if (kid != null && kid.getNodeType() == 1) {
                        LOGGER.finest("adding to logic filter " + kid.getLocalName());
                        children.add(FilterDOMParser.parseFilter(kid));
                    }
                    ++i;
                }
                if (childName.equals("And")) {
                    return FILTER_FACT.and(children);
                }
                if (childName.equals("Or")) {
                    return FILTER_FACT.or(children);
                }
                if (childName.equals("Not")) {
                    if (children.size() != 1) {
                        throw new IllegalFilterException("Filter negation can be applied to one and only one child filter");
                    }
                    return FILTER_FACT.not((Filter)children.get(0));
                }
                throw new RuntimeException("Logical filter, but not And, Or, Not? This should not happen");
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build filter: " + (Object)((Object)ife));
                return null;
            }
        }
        LOGGER.warning("unknown filter " + root);
        return null;
    }

    private static PropertyIsNull parseNullFilter(Node nullNode) throws IllegalFilterException {
        LOGGER.finest("parsing null node: " + nullNode);
        Node value = nullNode.getFirstChild();
        while (value.getNodeType() != 1) {
            value = value.getNextSibling();
        }
        LOGGER.finest("add null value -> " + value + "<-");
        Expression expr = ExpressionDOMParser.parseExpression(value);
        return FILTER_FACT.isNull(expr);
    }
}

