/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.capability;

import java.util.Arrays;
import java.util.List;
import org.geotools.filter.capability.OperatorImpl;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.capability.Operator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionNameImpl
extends OperatorImpl
implements FunctionName {
    int argumentCount;
    List<String> argumentNames;

    public FunctionNameImpl(String name, int argumentCount) {
        super(name);
        this.argumentCount = argumentCount;
        this.argumentNames = null;
    }

    public FunctionNameImpl(String name, String[] argumentsNames) {
        super(name);
        this.argumentCount = argumentsNames.length;
        this.argumentNames = FunctionNameImpl.generateArgumentNames(this.argumentCount, argumentsNames);
    }

    public FunctionNameImpl(String name, List<String> argumentsNames) {
        super(name);
        this.argumentCount = argumentsNames.size();
        this.argumentNames = FunctionNameImpl.generateArgumentNames(this.argumentCount, argumentsNames);
    }

    public FunctionNameImpl(FunctionName copy) {
        super((Operator)copy);
        this.argumentCount = copy.getArgumentCount();
        this.argumentNames = FunctionNameImpl.generateArgumentNames(this.argumentCount, copy.getArgumentNames());
    }

    public void setArgumentCount(int argumentCount) {
        this.argumentCount = argumentCount;
        this.argumentNames = FunctionNameImpl.generateArgumentNames(argumentCount, this.argumentNames);
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.argumentCount;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionNameImpl other = (FunctionNameImpl)obj;
        return this.argumentCount == other.argumentCount;
    }

    public void setArgumentNames(List<String> argumentNames) {
        this.argumentNames = argumentNames;
    }

    public List<String> getArgumentNames() {
        if (this.argumentNames == null) {
            this.argumentNames = FunctionNameImpl.generateArgumentNames(this.argumentCount);
        }
        return this.argumentNames;
    }

    private static List<String> generateArgumentNames(int count) {
        List<String> names = Arrays.asList(new String[count]);
        int i = 0;
        while (i < count) {
            names.set(i, "arg" + i);
            ++i;
        }
        return names;
    }

    private static List<String> generateArgumentNames(int count, List<String> copy) {
        List<String> names = Arrays.asList(new String[count]);
        int i = 0;
        while (i < count) {
            String name = "arg" + i;
            if (copy != null && i < copy.size() && copy.get(i) != null) {
                name = copy.get(i);
            }
            names.set(i, name);
            ++i;
        }
        return names;
    }

    private static List<String> generateArgumentNames(int count, String[] copy) {
        List<String> names = Arrays.asList(new String[count]);
        int i = 0;
        while (i < count) {
            String name = "arg" + i;
            if (copy != null && i < copy.length && copy[i] != null) {
                name = copy[i];
            }
            names.set(i, name);
            ++i;
        }
        return names;
    }
}

