/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.filter.expression.DirectPropertyAccessorFactory;
import org.geotools.filter.expression.NullPropertyAccessorFactory;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.expression.SimpleFeaturePropertyAccessorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccessors {
    static final PropertyAccessorFactory[] FACTORY_CACHE;

    static {
        ArrayList<Object> cache = new ArrayList<Object>();
        cache.add(new NullPropertyAccessorFactory());
        cache.add(new SimpleFeaturePropertyAccessorFactory());
        cache.add(new DirectPropertyAccessorFactory());
        Iterator factories = FactoryRegistry.lookupProviders(PropertyAccessorFactory.class);
        while (factories.hasNext()) {
            Object factory = factories.next();
            if (factory instanceof SimpleFeaturePropertyAccessorFactory || factory instanceof DirectPropertyAccessorFactory || factory instanceof NullPropertyAccessorFactory) continue;
            cache.add((PropertyAccessorFactory)factory);
        }
        FACTORY_CACHE = cache.toArray(new PropertyAccessorFactory[cache.size()]);
    }

    private PropertyAccessors() {
    }

    public static PropertyAccessor findPropertyAccessor(Object object, String xpath, Class target, Hints hints) {
        if (object == null) {
            return null;
        }
        PropertyAccessorFactory[] propertyAccessorFactoryArray = FACTORY_CACHE;
        int n = FACTORY_CACHE.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyAccessorFactory factory = propertyAccessorFactoryArray[n2];
            PropertyAccessor accessor = factory.createPropertyAccessor(object.getClass(), xpath, target, hints);
            if (accessor != null && accessor.canHandle(object, xpath, target)) {
                return accessor;
            }
            ++n2;
        }
        return null;
    }

    public static List<PropertyAccessor> findPropertyAccessors(Object object, String xpath, Class target, Hints hints) {
        if (object == null) {
            return null;
        }
        ArrayList<PropertyAccessor> list = new ArrayList<PropertyAccessor>();
        PropertyAccessorFactory[] propertyAccessorFactoryArray = FACTORY_CACHE;
        int n = FACTORY_CACHE.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyAccessorFactory factory = propertyAccessorFactoryArray[n2];
            PropertyAccessor accessor = factory.createPropertyAccessor(object.getClass(), xpath, target, hints);
            if (accessor != null && accessor.canHandle(object, xpath, target)) {
                list.add(accessor);
            }
            ++n2;
        }
        return list;
    }
}

