/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualIntervalFunction
extends ClassificationFunction {
    public EqualIntervalFunction() {
        this.setName("EqualInterval");
    }

    private RangedClassifier calculate(SimpleFeatureCollection featureCollection) {
        MaxVisitor maxVisit;
        Comparable globalMin;
        int classNum;
        block8: {
            MinVisitor minVisit;
            block7: {
                classNum = this.getClasses();
                minVisit = new MinVisitor((Expression)this.getExpression());
                if (this.progress == null) {
                    this.progress = new NullProgressListener();
                }
                featureCollection.accepts((FeatureVisitor)minVisit, (ProgressListener)this.progress);
                if (!this.progress.isCanceled()) break block7;
                return null;
            }
            globalMin = (Comparable)minVisit.getResult().getValue();
            maxVisit = new MaxVisitor((Expression)this.getExpression());
            featureCollection.accepts((FeatureVisitor)maxVisit, (ProgressListener)this.progress);
            if (!this.progress.isCanceled()) break block8;
            return null;
        }
        try {
            Comparable globalMax = (Comparable)maxVisit.getResult().getValue();
            if (globalMin instanceof Number && globalMax instanceof Number) {
                return this.calculateNumerical(classNum, globalMin, globalMax);
            }
            return this.calculateNonNumerical(classNum, (FeatureCollection<?, ?>)featureCollection);
        }
        catch (IllegalFilterException e) {
            LOGGER.log(Level.SEVERE, "EqualIntervalFunction calculate(SimpleFeatureCollection) failed", e);
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "EqualIntervalFunction calculate(SimpleFeatureCollection) failed", e);
            return null;
        }
    }

    private RangedClassifier calculateNumerical(int classNum, Comparable globalMin, Comparable globalMax) {
        double slotWidth = (((Number)((Object)globalMax)).doubleValue() - ((Number)((Object)globalMin)).doubleValue()) / (double)classNum;
        Comparable[] localMin = new Comparable[classNum];
        Comparable[] localMax = new Comparable[classNum];
        int i = 0;
        while (i < classNum) {
            localMin[i] = new Double(((Number)((Object)globalMin)).doubleValue() + (double)i * slotWidth);
            localMax[i] = new Double(((Number)((Object)globalMax)).doubleValue() - (double)(classNum - i - 1) * slotWidth);
            int decPlaces = this.decimalPlaces(slotWidth);
            if (decPlaces > -1) {
                localMin[i] = new Double(this.round(((Number)((Object)localMin[i])).doubleValue(), decPlaces));
                localMax[i] = new Double(this.round(((Number)((Object)localMax[i])).doubleValue(), decPlaces));
            }
            if (i == 0) {
                if (localMin[i].compareTo(new Double(((Number)((Object)globalMin)).doubleValue())) < 0) {
                    localMin[i] = new Double(this.fixRound(((Number)((Object)localMin[i])).doubleValue(), decPlaces, false));
                }
            } else if (i == classNum - 1 && localMax[i].compareTo(new Double(((Number)((Object)globalMax)).doubleValue())) > 0) {
                localMax[i] = new Double(this.fixRound(((Number)((Object)localMax[i])).doubleValue(), decPlaces, true));
            }
            if (i != 0 && !localMin[i].equals(localMax[i - 1])) {
                localMin[i] = localMax[i - 1];
            }
            ++i;
        }
        return new RangedClassifier(localMin, localMax);
    }

    private RangedClassifier calculateNonNumerical(int classNum, FeatureCollection<?, ?> featureCollection) throws IOException {
        UniqueVisitor uniqueVisit = new UniqueVisitor((Expression)this.getExpression());
        featureCollection.accepts((FeatureVisitor)uniqueVisit, (ProgressListener)new NullProgressListener());
        List result = uniqueVisit.getResult().toList();
        Collections.sort(result);
        Comparable[] values = result.toArray(new Comparable[result.size()]);
        Comparable[] localMin = new Comparable[classNum];
        Comparable[] localMax = new Comparable[classNum];
        int binPop = new Double(Math.ceil((double)values.length / (double)classNum)).intValue();
        int lastBigBin = values.length % classNum;
        lastBigBin = lastBigBin == 0 ? classNum : --lastBigBin;
        int itemIndex = 0;
        int binIndex = 0;
        while (binIndex < classNum) {
            if (binIndex < localMin.length) {
                localMin[binIndex] = itemIndex < values.length ? values[itemIndex] : values[values.length - 1];
            } else {
                localMin[localMin.length - 1] = itemIndex < values.length ? values[itemIndex] : values[values.length - 1];
            }
            itemIndex += binPop;
            if (binIndex == classNum - 1) {
                if (binIndex < localMax.length) {
                    localMax[binIndex] = itemIndex < values.length ? values[itemIndex] : values[values.length - 1];
                } else {
                    localMax[localMax.length - 1] = itemIndex < values.length ? values[itemIndex] : values[values.length - 1];
                }
            } else if (binIndex < localMax.length) {
                localMax[binIndex] = itemIndex + 1 < values.length ? values[itemIndex + 1] : values[values.length - 1];
            } else {
                Comparable comparable = localMax[localMax.length - 1] = itemIndex + 1 < values.length ? values[itemIndex + 1] : values[values.length - 1];
            }
            if (lastBigBin == binIndex) {
                --binPop;
            }
            ++binIndex;
        }
        return new RangedClassifier(localMin, localMax);
    }

    @Override
    public RangedClassifier evaluate(Object object) {
        if (!(object instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)object);
    }

    @Override
    public int getArgCount() {
        return 2;
    }
}

