/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.util.ProgressListener;

public class JenksNaturalBreaksFunction
extends ClassificationFunction {
    ProgressListener progress;
    private static final Logger logger = Logging.getLogger((String)"org.geotools.filter.function");

    public JenksNaturalBreaksFunction() {
        this.setName("Jenks");
    }

    public int getArgCount() {
        return 2;
    }

    public Object evaluate(Object feature) {
        if (!(feature instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)feature);
    }

    private Object calculate(SimpleFeatureCollection featureCollection) {
        SimpleFeatureIterator features = featureCollection.features();
        ArrayList<Double> data = new ArrayList<Double>();
        try {
            while (features.hasNext()) {
                Double e;
                SimpleFeature feature = (SimpleFeature)features.next();
                Object result = this.getExpression().evaluate(feature);
                logger.finest("importing " + result);
                if (result == null || (e = new Double(result.toString())).isInfinite() || e.isNaN()) continue;
                data.add(e);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        Collections.sort(data);
        int k = this.getClasses();
        int m = data.size();
        if (k == m) {
            logger.info("Number of classes (" + k + ") is equal to number of data points (" + m + ") " + "unique classification returned");
            Comparable[] localMin = new Comparable[k];
            Comparable[] localMax = new Comparable[k];
            int id = 0;
            while (id < k - 1) {
                localMax[id] = (Comparable)data.get(id + 1);
                localMin[id] = (Comparable)data.get(id);
                ++id;
            }
            localMax[k - 1] = (Comparable)data.get(k - 1);
            localMin[k - 1] = (Comparable)data.get(k - 1);
            return new RangedClassifier(localMin, localMax);
        }
        int[][] iwork = new int[m + 1][k + 1];
        double[][] work = new double[m + 1][k + 1];
        int j = 1;
        while (j <= k) {
            iwork[0][j] = 1;
            iwork[1][j] = 1;
            work[1][j] = 0.0;
            int i = 2;
            while (i <= m) {
                work[i][j] = Double.MAX_VALUE;
                ++i;
            }
            ++j;
        }
        int i = 1;
        while (i <= m) {
            double s1 = 0.0;
            double s2 = 0.0;
            double var = 0.0;
            int ii = 1;
            while (ii <= i) {
                int i3 = i - ii + 1;
                double val = (Double)data.get(i3 - 1);
                double s0 = ii;
                var = (s2 += val * val) - (s1 += val) * s1 / s0;
                int ik = i3 - 1;
                if (ik != 0) {
                    int j2 = 2;
                    while (j2 <= k) {
                        if (work[i][j2] >= var + work[ik][j2 - 1]) {
                            iwork[i][j2] = i3 - 1;
                            work[i][j2] = var + work[ik][j2 - 1];
                        }
                        ++j2;
                    }
                }
                ++ii;
            }
            iwork[i][1] = 1;
            work[i][1] = var;
            ++i;
        }
        if (logger.getLevel() == Level.FINER) {
            i = 0;
            while (i < m) {
                String tmp = String.valueOf(i) + ": " + data.get(i);
                int j3 = 2;
                while (j3 <= k) {
                    tmp = String.valueOf(tmp) + "\t" + iwork[i][j3];
                    ++j3;
                }
                logger.finer(tmp);
                ++i;
            }
        }
        int ik = m - 1;
        Comparable[] localMin = new Comparable[k];
        Comparable[] localMax = new Comparable[k];
        localMax[k - 1] = (Comparable)data.get(ik);
        int j4 = k;
        while (j4 >= 2) {
            logger.finest("index " + ik + ", class" + j4);
            int id = iwork[ik][j4] - 1;
            localMax[j4 - 2] = (Comparable)data.get(id);
            localMin[j4 - 1] = (Comparable)data.get(id);
            ik = iwork[ik][j4] - 1;
            --j4;
        }
        localMin[0] = (Comparable)data.get(0);
        return new RangedClassifier(localMin, localMax);
    }
}

