/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.filter.function.Classifier;

public final class RangedClassifier
extends Classifier {
    Comparable[] min;
    Comparable[] max;

    public RangedClassifier(Comparable[] min, Comparable[] max) {
        this.min = min;
        this.max = max;
        this.titles = new String[min.length];
        int i = 0;
        while (i < this.titles.length) {
            this.titles[i] = String.valueOf(this.truncateZeros(min[i].toString())) + ".." + this.truncateZeros(max[i].toString());
            ++i;
        }
    }

    private String truncateZeros(String str) {
        if (str.indexOf(".") > -1) {
            while (str.endsWith("0")) {
                str = str.substring(0, str.length() - 1);
            }
            if (str.endsWith(".")) {
                str = str.substring(0, str.length() - 1);
            }
        }
        return str;
    }

    public int getSize() {
        return Math.min(this.min.length, this.max.length);
    }

    public Object getMin(int slot) {
        return this.min[slot];
    }

    public Object getMax(int slot) {
        return this.max[slot];
    }

    public int classify(Object value) {
        return this.classify((Comparable)value);
    }

    private int classify(Comparable val) {
        Comparable value = val;
        if (val instanceof Integer) {
            value = new Double(((Integer)val).intValue());
        }
        int last = this.min.length - 1;
        int i = 0;
        while (i <= last) {
            Comparable localMin = this.min[i];
            Comparable localMax = this.max[i];
            if (localMin.compareTo(value) < 1 && localMax.compareTo(value) > 0) {
                return i;
            }
            ++i;
        }
        if (this.max[last].compareTo(value) == 0) {
            return last;
        }
        return -1;
    }
}

