/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

public class UniqueIntervalFunction
extends ClassificationFunction {
    public UniqueIntervalFunction() {
        this.setName("UniqueInterval");
    }

    private Object calculate(SimpleFeatureCollection featureCollection) {
        CalcResult calcResult;
        int classNum;
        block13: {
            UniqueVisitor uniqueVisit;
            block12: {
                classNum = this.getClasses();
                uniqueVisit = new UniqueVisitor((Expression)this.getExpression());
                if (this.progress == null) {
                    this.progress = new NullProgressListener();
                }
                featureCollection.accepts((FeatureVisitor)uniqueVisit, (ProgressListener)this.progress);
                if (!this.progress.isCanceled()) break block12;
                return null;
            }
            calcResult = uniqueVisit.getResult();
            if (calcResult != null) break block13;
            return null;
        }
        try {
            Set[] values;
            List result = calcResult.toList();
            Collections.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null) {
                        if (o2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1 instanceof String && o2 instanceof String) {
                        return ((String)o1).compareTo((String)o2);
                    }
                    return 0;
                }
            });
            Object[] results = result.toArray();
            if (classNum < results.length) {
                values = new Set[classNum];
                int binPop = new Double(Math.ceil((double)results.length / (double)classNum)).intValue();
                int lastBigBin = results.length % classNum;
                lastBigBin = lastBigBin == 0 ? classNum : --lastBigBin;
                int itemIndex = 0;
                int binIndex = 0;
                while (binIndex < classNum) {
                    HashSet<Object> val = new HashSet<Object>();
                    int binItem = 0;
                    while (binItem < binPop) {
                        val.add(results[itemIndex++]);
                        ++binItem;
                    }
                    if (lastBigBin == binIndex) {
                        --binPop;
                    }
                    values[binIndex] = val;
                    ++binIndex;
                }
            } else {
                if (classNum > results.length) {
                    classNum = results.length;
                }
                values = new Set[classNum];
                int i = 0;
                while (i < classNum) {
                    HashSet<Object> val = new HashSet<Object>();
                    val.add(results[i]);
                    values[i] = val;
                    ++i;
                }
            }
            return new ExplicitClassifier(values);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "UniqueIntervalFunction calculate failed", e);
            return null;
        }
    }

    public Object evaluate(Object feature) {
        if (!(feature instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)feature);
    }

    public int getArgCount() {
        return 2;
    }
}

