/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class IsStaticExpressionVisitor
implements ExpressionVisitor {
    public static final IsStaticExpressionVisitor VISITOR = new IsStaticExpressionVisitor();

    protected IsStaticExpressionVisitor() {
    }

    public Boolean visit(NilExpression expression, Object data) {
        return true;
    }

    public Boolean visit(Add expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept((ExpressionVisitor)this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept((ExpressionVisitor)this, data);
        return isStatic;
    }

    public Boolean visit(Divide expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept((ExpressionVisitor)this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept((ExpressionVisitor)this, data);
        return isStatic;
    }

    public Boolean visit(Function expression, Object data) {
        boolean isStatic = true;
        if (expression.getParameters() != null) {
            for (Expression parameter : expression.getParameters()) {
                isStatic = (Boolean)parameter.accept((ExpressionVisitor)this, data);
                if (!isStatic) break;
            }
        }
        return isStatic;
    }

    public Boolean visit(Literal expression, Object data) {
        return true;
    }

    public Boolean visit(Multiply expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept((ExpressionVisitor)this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept((ExpressionVisitor)this, data);
        return isStatic;
    }

    public Boolean visit(PropertyName expression, Object data) {
        return false;
    }

    public Boolean visit(Subtract expression, Object data) {
        boolean isStatic = (Boolean)expression.getExpression1().accept((ExpressionVisitor)this, data);
        if (!isStatic) {
            return false;
        }
        isStatic = (Boolean)expression.getExpression2().accept((ExpressionVisitor)this, data);
        return isStatic;
    }
}

