/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.capability.ArithmeticOperators;
import org.opengis.filter.capability.ComparisonOperators;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.capability.Functions;
import org.opengis.filter.capability.ScalarCapabilities;
import org.opengis.filter.capability.SpatialCapabilities;
import org.opengis.filter.capability.SpatialOperators;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class IsSupportedFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    private FilterCapabilities capabilities;

    public IsSupportedFilterVisitor(FilterCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return false;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return false;
    }

    public Object visit(And filter, Object extraData) {
        if (this.capabilities.getScalarCapabilities() != null && this.capabilities.getScalarCapabilities().hasLogicalOperators()) {
            return true;
        }
        return false;
    }

    public Object visit(Id filter, Object extraData) {
        if (this.capabilities.getIdCapabilities() != null && (this.capabilities.getIdCapabilities().hasFID() || this.capabilities.getIdCapabilities().hasEID())) {
            return true;
        }
        return false;
    }

    public Object visit(Not filter, Object extraData) {
        if (this.capabilities.getScalarCapabilities() != null && this.capabilities.getScalarCapabilities().hasLogicalOperators()) {
            return true;
        }
        return false;
    }

    public Object visit(Or filter, Object extraData) {
        if (this.capabilities.getScalarCapabilities() != null && this.capabilities.getScalarCapabilities().hasLogicalOperators()) {
            return true;
        }
        return false;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Between") != null) {
            return true;
        }
        return false;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("EqualTo") != null) {
            return true;
        }
        return false;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("NotEqualTo") != null) {
            return true;
        }
        return false;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("GreaterThan") != null) {
            return true;
        }
        return false;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("GreaterThanOrEqualTo") != null) {
            return true;
        }
        return false;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("LessThan") != null) {
            return true;
        }
        return false;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("LessThanOrEqualTo") != null) {
            return true;
        }
        return false;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Like") != null) {
            return true;
        }
        return false;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ComparisonOperators operators = scalar.getComparisonOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("NullCheck") != null) {
            return true;
        }
        return false;
    }

    public Object visit(BBOX filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("BBOX") != null) {
            return true;
        }
        return false;
    }

    public Object visit(Beyond filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Beyond") != null) {
            return true;
        }
        return false;
    }

    public Object visit(Contains filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Contains") != null) {
            return true;
        }
        return false;
    }

    public Object visit(Crosses filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Crosses") != null) {
            return true;
        }
        return false;
    }

    public Object visit(Disjoint filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Disjoint") != null) {
            return true;
        }
        return false;
    }

    public Object visit(DWithin filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("DWithin") != null) {
            return true;
        }
        return false;
    }

    public Object visit(Equals filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Equals") != null) {
            return true;
        }
        return false;
    }

    public Object visit(Intersects filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Intersects") != null) {
            return true;
        }
        return false;
    }

    public Object visit(Overlaps filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Overlaps") != null) {
            return true;
        }
        return false;
    }

    public Object visit(Touches filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Touches") != null) {
            return true;
        }
        return false;
    }

    public Object visit(Within filter, Object extraData) {
        SpatialCapabilities spatial = this.capabilities.getSpatialCapabilities();
        if (spatial == null) {
            return false;
        }
        SpatialOperators operators = spatial.getSpatialOperators();
        if (operators == null) {
            return false;
        }
        if (operators.getOperator("Within") != null) {
            return true;
        }
        return false;
    }

    public Object visitNullFilter(Object extraData) {
        return false;
    }

    public Object visit(NilExpression expression, Object extraData) {
        return false;
    }

    public Object visit(Add expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    public Object visit(Divide expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    public Object visit(Function function, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        Functions functions = operators.getFunctions();
        if (functions == null) {
            return false;
        }
        FunctionName found = functions.getFunctionName(function.getName());
        if (found != null) {
            return true;
        }
        return false;
    }

    public Object visit(Literal expression, Object extraData) {
        return true;
    }

    public Object visit(Multiply expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }

    public Object visit(PropertyName expression, Object extraData) {
        return true;
    }

    public Object visit(Subtract expression, Object extraData) {
        ScalarCapabilities scalar = this.capabilities.getScalarCapabilities();
        if (scalar == null) {
            return false;
        }
        ArithmeticOperators operators = scalar.getArithmeticOperators();
        if (operators == null) {
            return false;
        }
        return operators.hasSimpleArithmetic();
    }
}

