/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.VolatileFunction;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.identity.Identifier;

public class SimplifyingFilterVisitor
extends DuplicatingFilterVisitor {
    static final boolean SIMPLIFY_STABLE_FUNCTIONS = Boolean.getBoolean("org.geotools.filter.function.simplify");
    VolatileFilterAttributeExtractor attributeExtractor;
    public static final FIDValidator ANY_FID_VALID = new FIDValidator(){

        public boolean isValid(String fid) {
            return true;
        }
    };
    private FIDValidator fidValidator = ANY_FID_VALID;

    public void setFIDValidator(FIDValidator validator) {
        this.fidValidator = validator == null ? ANY_FID_VALID : validator;
    }

    public Object visit(And filter, Object extraData) {
        ArrayList<Filter> newChildren = new ArrayList<Filter>(filter.getChildren().size());
        for (Filter child : filter.getChildren()) {
            Filter cloned = (Filter)child.accept((FilterVisitor)this, extraData);
            if (cloned == Filter.EXCLUDE) {
                return Filter.EXCLUDE;
            }
            if (cloned == Filter.INCLUDE) continue;
            newChildren.add(cloned);
        }
        if (newChildren.size() == 0) {
            return Filter.INCLUDE;
        }
        if (newChildren.size() == 1) {
            return newChildren.get(0);
        }
        return this.getFactory(extraData).and(newChildren);
    }

    public Object visit(Or filter, Object extraData) {
        ArrayList<Filter> newChildren = new ArrayList<Filter>(filter.getChildren().size());
        for (Filter child : filter.getChildren()) {
            Filter cloned = (Filter)child.accept((FilterVisitor)this, extraData);
            if (cloned == Filter.INCLUDE) {
                return Filter.INCLUDE;
            }
            if (cloned == Filter.EXCLUDE) continue;
            newChildren.add(cloned);
        }
        if (newChildren.size() == 0) {
            return Filter.EXCLUDE;
        }
        if (newChildren.size() == 1) {
            return newChildren.get(0);
        }
        return this.getFactory(extraData).or(newChildren);
    }

    public Object visit(Id filter, Object extraData) {
        if (filter.getIDs().size() == 0) {
            return Filter.EXCLUDE;
        }
        HashSet<Identifier> validFids = new HashSet<Identifier>();
        for (Identifier id : filter.getIdentifiers()) {
            if (!(id instanceof FeatureId) && !(id instanceof GmlObjectId) || !this.fidValidator.isValid((String)id.getID())) continue;
            validFids.add(id);
        }
        Object validIdFilter = validFids.size() == 0 ? Filter.EXCLUDE : this.getFactory(extraData).id(validFids);
        return validIdFilter;
    }

    public Object visit(Not filter, Object extraData) {
        if (filter.getFilter() instanceof Not) {
            Not inner = (Not)filter.getFilter();
            return inner.getFilter().accept((FilterVisitor)this, extraData);
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Function function, Object extraData) {
        if (!SIMPLIFY_STABLE_FUNCTIONS) {
            return super.visit(function, extraData);
        }
        if (function instanceof VolatileFunction) {
            return super.visit(function, extraData);
        }
        if (this.attributeExtractor == null) {
            this.attributeExtractor = new VolatileFilterAttributeExtractor();
        } else {
            this.attributeExtractor.clear();
        }
        function.accept((ExpressionVisitor)this.attributeExtractor, null);
        if (this.attributeExtractor.getAttributeNameSet().isEmpty() && !this.attributeExtractor.usingVolatileFunctions) {
            Object result = function.evaluate(null);
            return this.ff.literal(result);
        }
        return super.visit(function, extraData);
    }

    public static interface FIDValidator {
        public boolean isValid(String var1);
    }

    public static class RegExFIDValidator
    implements FIDValidator {
        private Pattern pattern;

        public RegExFIDValidator(String regularExpression) {
            this.pattern = Pattern.compile(regularExpression);
        }

        public boolean isValid(String fid) {
            return this.pattern.matcher(fid).matches();
        }
    }

    public static class TypeNameDotNumberFidValidator
    extends RegExFIDValidator {
        public TypeNameDotNumberFidValidator(String typeName) {
            super(String.valueOf(typeName) + "\\.\\d+");
        }
    }

    static class VolatileFilterAttributeExtractor
    extends FilterAttributeExtractor {
        boolean usingVolatileFunctions;

        VolatileFilterAttributeExtractor() {
        }

        public void clear() {
            super.clear();
            this.usingVolatileFunctions = false;
        }

        public Object visit(Function expression, Object data) {
            if (expression instanceof VolatileFunction) {
                this.usingVolatileFunctions = true;
            }
            return super.visit(expression, data);
        }
    }
}

