/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Geometries {
    POINT(Point.class, 2001),
    LINESTRING(LineString.class, 2002),
    POLYGON(Polygon.class, 2003),
    MULTIPOINT(MultiPoint.class, 2004),
    MULTILINESTRING(MultiLineString.class, 2005),
    MULTIPOLYGON(MultiPolygon.class, 2006),
    GEOMETRY(Geometry.class, 2007),
    GEOMETRYCOLLECTION(GeometryCollection.class, 2008);

    private final Class<? extends Geometry> binding;
    private final int sqlType;
    private final String name;
    private final String simpleName;

    private Geometries(Class<? extends Geometry> type, int sqlType) {
        this.binding = type;
        this.sqlType = sqlType;
        this.name = type.getSimpleName();
        this.simpleName = this.name.startsWith("Multi") ? this.name.substring(5) : this.name;
    }

    public Class<? extends Geometry> getBinding() {
        return this.binding;
    }

    public Integer getSQLType() {
        return this.sqlType;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public static Geometries get(Geometry geom) {
        if (geom != null) {
            return Geometries.getForBinding(geom.getClass());
        }
        return null;
    }

    public static Geometries getForBinding(Class<? extends Geometry> geomClass) {
        Geometries[] geometriesArray = Geometries.values();
        int n = geometriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Geometries gt = geometriesArray[n2];
            if (gt.binding == geomClass) {
                return gt;
            }
            ++n2;
        }
        Geometries match = null;
        Geometries[] geometriesArray2 = Geometries.values();
        int n3 = geometriesArray2.length;
        n = 0;
        while (n < n3) {
            Geometries gt = geometriesArray2[n];
            if (gt != GEOMETRY && gt != GEOMETRYCOLLECTION && gt.binding.isAssignableFrom(geomClass)) {
                if (match == null) {
                    match = gt;
                } else {
                    return null;
                }
            }
            ++n;
        }
        if (match == null) {
            if (GeometryCollection.class.isAssignableFrom(geomClass)) {
                return GEOMETRYCOLLECTION;
            }
            if (Geometry.class.isAssignableFrom(geomClass)) {
                return GEOMETRY;
            }
        }
        return match;
    }

    public static Geometries getForName(String name) {
        Geometries[] geometriesArray = Geometries.values();
        int n = geometriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Geometries gt = geometriesArray[n2];
            if (gt.getName().equalsIgnoreCase(name)) {
                return gt;
            }
            ++n2;
        }
        return null;
    }

    public static Geometries getForSQLType(int sqlType) {
        Geometries[] geometriesArray = Geometries.values();
        int n = geometriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Geometries gt = geometriesArray[n2];
            if (gt.sqlType == sqlType) {
                return gt;
            }
            ++n2;
        }
        return null;
    }
}

