/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import java.util.ArrayList;
import java.util.List;

public class GeometryCollector {
    List<Geometry> geometries = new ArrayList<Geometry>();
    GeometryFactory factory = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory());
    long coordinates = 0L;
    long maxCoordinates = -1L;

    public long getMaxCoordinates() {
        return this.maxCoordinates;
    }

    public void setMaxCoordinates(long maxCoordinates) {
        this.maxCoordinates = maxCoordinates;
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public void setFactory(GeometryFactory factory) {
        this.factory = factory;
    }

    public GeometryCollection collect() {
        Class collectionClass;
        if (this.geometries.isEmpty()) {
            return new GeometryCollection(null, this.factory == null ? new GeometryFactory() : this.factory);
        }
        GeometryFactory gf = this.factory;
        if (gf == null) {
            gf = this.geometries.get(0).getFactory();
        }
        if (gf == null) {
            gf = new GeometryFactory();
        }
        if ((collectionClass = this.guessCollectionType()) == MultiPoint.class) {
            Point[] array = this.geometries.toArray(new Point[this.geometries.size()]);
            return gf.createMultiPoint(array);
        }
        if (collectionClass == MultiPolygon.class) {
            Polygon[] array = this.geometries.toArray(new Polygon[this.geometries.size()]);
            return gf.createMultiPolygon(array);
        }
        if (collectionClass == MultiLineString.class) {
            LineString[] array = this.geometries.toArray(new LineString[this.geometries.size()]);
            return gf.createMultiLineString(array);
        }
        Geometry[] array = this.geometries.toArray(new Geometry[this.geometries.size()]);
        return gf.createGeometryCollection(array);
    }

    private Class guessCollectionType() {
        if (this.geometries == null || this.geometries.size() == 0) {
            return GeometryCollection.class;
        }
        Class result = this.baseType(this.geometries.get(0).getClass());
        int i = 1;
        while (i < this.geometries.size()) {
            Class<?> curr = this.geometries.get(i).getClass();
            if (curr != result && !result.isAssignableFrom(curr)) {
                return GeometryCollection.class;
            }
            ++i;
        }
        if (result == Point.class) {
            return MultiPoint.class;
        }
        if (result == LineString.class) {
            return MultiLineString.class;
        }
        if (result == Polygon.class) {
            return MultiPolygon.class;
        }
        return GeometryCollection.class;
    }

    private Class baseType(Class geometry) {
        if (Polygon.class.isAssignableFrom(geometry)) {
            return Polygon.class;
        }
        if (LineString.class.isAssignableFrom(geometry)) {
            return LineString.class;
        }
        if (Point.class.isAssignableFrom(geometry)) {
            return Point.class;
        }
        return geometry;
    }

    public void add(Geometry g) {
        if (g == null) {
            return;
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            int i = 0;
            while (i < gc.getNumGeometries()) {
                this.add(gc.getGeometryN(i));
                ++i;
            }
        } else {
            this.coordinates += (long)g.getNumPoints();
            if (this.maxCoordinates > 0L && this.coordinates > this.maxCoordinates) {
                throw new IllegalStateException("Max number of collected ordinates has been exceeded. Current count is " + this.coordinates + ", max count is " + this.maxCoordinates);
            }
            if (this.factory != null) {
                g = this.factory.createGeometry(g);
            }
            this.geometries.add(g);
        }
    }
}

