/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.util.Arrays;
import java.util.Iterator;
import org.geotools.data.DataTestCase;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MemoryFeatureCollectionTest
extends DataTestCase {
    private MemoryFeatureCollection roads;

    public MemoryFeatureCollectionTest(String test) {
        super(test);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.roads = new MemoryFeatureCollection(this.roadType);
        this.roads.addAll(Arrays.asList(this.roadFeatures));
    }

    public void testAdd() {
        MemoryFeatureCollection rivers = new MemoryFeatureCollection(this.riverType);
        for (int i = 0; i < this.riverFeatures.length; ++i) {
            rivers.add(this.riverFeatures[i]);
        }
        MemoryFeatureCollectionTest.assertEquals((int)this.riverFeatures.length, (int)rivers.size());
    }

    public void testAddAll() {
        MemoryFeatureCollection rivers = new MemoryFeatureCollection(this.riverType);
        rivers.addAll(Arrays.asList(this.riverFeatures));
    }

    public void testSize() {
        MemoryFeatureCollectionTest.assertEquals((int)this.roadFeatures.length, (int)this.roads.size());
    }

    public void testResources() {
        Object[] array = this.roads.toArray();
        this.roads.purge();
        MemoryFeatureCollectionTest.assertEquals((int)this.roads.size(), (int)array.length);
        Iterator i = this.roads.iterator();
        MemoryFeatureCollectionTest.assertTrue((boolean)i.hasNext());
        this.roads.close(i);
        try {
            MemoryFeatureCollectionTest.assertFalse((boolean)i.hasNext());
            MemoryFeatureCollectionTest.fail((String)"should be closed");
        }
        catch (IllegalStateException closed) {
            // empty catch block
        }
        i = this.roads.iterator();
        MemoryFeatureCollectionTest.assertTrue((boolean)i.hasNext());
        this.roads.purge();
        try {
            MemoryFeatureCollectionTest.assertFalse((boolean)i.hasNext());
            MemoryFeatureCollectionTest.fail((String)"should be closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testBounds() {
        MemoryFeatureCollection rivers = new MemoryFeatureCollection(this.riverType);
        ReferencedEnvelope expected = new ReferencedEnvelope();
        for (int i = 0; i < this.riverFeatures.length; ++i) {
            rivers.add(this.riverFeatures[i]);
            expected.include(this.riverFeatures[i].getBounds());
        }
        MemoryFeatureCollectionTest.assertEquals((int)this.riverFeatures.length, (int)rivers.size());
        MemoryFeatureCollectionTest.assertNotNull((Object)rivers.getBounds());
        MemoryFeatureCollectionTest.assertEquals((Object)expected, (Object)rivers.getBounds());
    }

    public void testSubCollection() {
        SimpleFeatureCollection sub = this.roads.subCollection(this.rd12Filter);
        MemoryFeatureCollectionTest.assertEquals((int)2, (int)sub.size());
    }

    public void testSubSubCollection() {
        SimpleFeatureCollection sub = this.roads.subCollection(this.rd12Filter);
        SimpleFeatureCollection subsub = sub.subCollection(this.rd1Filter);
        MemoryFeatureCollectionTest.assertEquals((int)1, (int)subsub.size());
    }

    public void XtestSort() {
    }
}

